/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.netxms.client.datacollection.TableCondition;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.api.TableColumnEnumerator;
import org.netxms.ui.eclipse.widgets.DashboardComposite;

public class TableConditionsEditor
extends Composite {
    private FormToolkit toolkit;
    private ScrolledForm form;
    private ImageHyperlink addColumnLink;
    private List<GroupEditor> groups = new ArrayList<GroupEditor>();
    private TableColumnEnumerator columnEnumerator = null;
    private List<String> columnList;

    public TableConditionsEditor(Composite parent, int style, TableColumnEnumerator columnEnumerator) {
        super(parent, style);
        this.columnEnumerator = columnEnumerator;
        this.setLayout((Layout)new FillLayout());
        this.toolkit = new FormToolkit(this.getDisplay());
        this.form = this.toolkit.createScrolledForm((Composite)this);
        this.form.getBody().setLayout((Layout)new GridLayout());
        this.addColumnLink = this.toolkit.createImageHyperlink(this.form.getBody(), 0);
        Messages.get();
        this.addColumnLink.setText(Messages.TableConditionsEditor_Add);
        this.addColumnLink.setImage(SharedIcons.IMG_ADD_OBJECT);
        Messages.get();
        this.addColumnLink.setToolTipText(Messages.TableConditionsEditor_AddCondGroup);
        this.addColumnLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TableConditionsEditor.this.addGroup((Control)TableConditionsEditor.this.addColumnLink, null);
            }
        });
    }

    public void setConditions(List<List<TableCondition>> conditions) {
        for (List<TableCondition> g : conditions) {
            this.addGroup((Control)this.addColumnLink, g);
        }
        this.form.reflow(true);
    }

    public List<List<TableCondition>> getConditions() {
        ArrayList<List<TableCondition>> result = new ArrayList<List<TableCondition>>(this.groups.size());
        for (GroupEditor ge : this.groups) {
            result.add(ge.getConditions());
        }
        return result;
    }

    private void addGroup(Control lastControl, List<TableCondition> initialData) {
        GroupEditor editor = new GroupEditor(this.form.getBody());
        editor.moveAbove(lastControl);
        editor.setLayoutData(new GridData(4, 128, true, false));
        this.groups.add(editor);
        if (initialData != null) {
            for (TableCondition c : initialData) {
                editor.addCondition(c);
            }
        } else {
            this.form.reflow(true);
        }
    }

    private void deleteGroup(GroupEditor editor) {
        this.groups.remove((Object)editor);
        editor.dispose();
        this.form.reflow(true);
    }

    private class ConditionEditor {
        private CCombo column;
        private CCombo operation;
        private Text value;

        public ConditionEditor(Composite parent, final GroupEditor group) {
            this.column = new CCombo(parent, 2056);
            TableConditionsEditor.this.toolkit.adapt((Composite)this.column);
            this.column.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            if (TableConditionsEditor.this.columnEnumerator != null) {
                TableConditionsEditor.this.columnList = TableConditionsEditor.this.columnEnumerator.getColumns();
                for (String s : TableConditionsEditor.this.columnList) {
                    this.column.add(s);
                }
            }
            this.operation = new CCombo(parent, 2056);
            TableConditionsEditor.this.toolkit.adapt((Composite)this.operation);
            this.operation.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            Messages.get();
            this.operation.add(Messages.EditThresholdDialog_LT);
            Messages.get();
            this.operation.add(Messages.EditThresholdDialog_LE);
            Messages.get();
            this.operation.add(Messages.EditThresholdDialog_EQ);
            Messages.get();
            this.operation.add(Messages.EditThresholdDialog_GE);
            Messages.get();
            this.operation.add(Messages.EditThresholdDialog_GT);
            Messages.get();
            this.operation.add(Messages.EditThresholdDialog_NE);
            Messages.get();
            this.operation.add(Messages.EditThresholdDialog_LIKE);
            Messages.get();
            this.operation.add(Messages.EditThresholdDialog_NOTLIKE);
            this.operation.add("like (ignore case)");
            this.operation.add("not like (ignore case)");
            this.value = TableConditionsEditor.this.toolkit.createText(parent, "", 2048);
            this.value.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            final ImageHyperlink link = TableConditionsEditor.this.toolkit.createImageHyperlink(parent, 0);
            link.setImage(SharedIcons.IMG_DELETE_OBJECT);
            Messages.get();
            link.setToolTipText(Messages.TableConditionsEditor_DeleteCond);
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    group.deleteCondition(ConditionEditor.this);
                    link.dispose();
                }
            });
            link.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        }

        public void dispose() {
            this.column.dispose();
            this.operation.dispose();
            this.value.dispose();
        }

        public TableCondition getCondition() {
            return new TableCondition(TableConditionsEditor.this.columnEnumerator == null ? this.column.getText() : TableConditionsEditor.this.columnList.get(this.column.getSelectionIndex()), this.operation.getSelectionIndex(), this.value.getText());
        }
    }

    private class GroupEditor
    extends DashboardComposite {
        private Composite content;
        private List<ConditionEditor> conditions;

        public GroupEditor(Composite parent) {
            super(parent, 2048);
            this.conditions = new ArrayList<ConditionEditor>();
            TableConditionsEditor.this.toolkit.adapt((Composite)this);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            this.setLayout((Layout)layout);
            this.content = TableConditionsEditor.this.toolkit.createComposite((Composite)this);
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.numColumns = 4;
            this.content.setLayout((Layout)layout);
            this.content.setLayoutData((Object)new GridData(4, 4, true, true));
            Composite buttons = TableConditionsEditor.this.toolkit.createComposite((Composite)this);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            buttons.setLayout((Layout)layout);
            buttons.setLayoutData((Object)new GridData(4, 128, false, false));
            ImageHyperlink link = TableConditionsEditor.this.toolkit.createImageHyperlink(buttons, 0);
            link.setImage(SharedIcons.IMG_DELETE_OBJECT);
            Messages.get();
            link.setToolTipText(Messages.TableConditionsEditor_DeleteCondGroup);
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    TableConditionsEditor.this.deleteGroup(GroupEditor.this);
                }
            });
            link = TableConditionsEditor.this.toolkit.createImageHyperlink((Composite)this, 0);
            link.setImage(SharedIcons.IMG_ADD_OBJECT);
            Messages.get();
            link.setText(Messages.TableConditionsEditor_Add);
            Messages.get();
            link.setToolTipText(Messages.TableConditionsEditor_AddCond);
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    GroupEditor.this.addCondition(null);
                }
            });
        }

        public List<TableCondition> getConditions() {
            ArrayList<TableCondition> result = new ArrayList<TableCondition>(this.conditions.size());
            for (ConditionEditor ce : this.conditions) {
                result.add(ce.getCondition());
            }
            return result;
        }

        private void addCondition(TableCondition initialData) {
            ConditionEditor editor = new ConditionEditor(this.content, this);
            this.conditions.add(editor);
            if (initialData != null) {
                editor.column.select(TableConditionsEditor.this.columnEnumerator == null ? -1 : TableConditionsEditor.this.columnList.indexOf(initialData.getColumn()));
                editor.operation.select(initialData.getOperation());
                editor.value.setText(initialData.getValue());
            } else {
                TableConditionsEditor.this.form.reflow(true);
            }
        }

        void deleteCondition(ConditionEditor editor) {
            this.conditions.remove(editor);
            editor.dispose();
            TableConditionsEditor.this.form.reflow(true);
        }
    }
}

