/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.compress;

import java.util.ArrayList;
import org.swtchart.internal.compress.Compress;

public class CompressBarSeries
extends Compress {
    @Override
    protected void addNecessaryPlots(ArrayList<Double> xList, ArrayList<Double> yList, ArrayList<Integer> indexList) {
        double prevX = this.xSeries[0];
        double maxY = Double.NaN;
        int prevIndex = 0;
        int i = 0;
        while (i < this.xSeries.length) {
            if (this.xSeries[i] >= this.config.getXLowerValue()) {
                if (this.isInSameGridXAsPrevious(this.xSeries[i])) {
                    if (maxY < this.ySeries[i]) {
                        maxY = this.ySeries[i];
                    }
                } else {
                    if (!Double.isNaN(maxY)) {
                        this.addToList(xList, yList, indexList, prevX, maxY, prevIndex);
                    }
                    prevX = this.xSeries[i];
                    maxY = this.ySeries[i];
                    prevIndex = i;
                }
            }
            if (this.xSeries[i] > this.config.getXUpperValue()) break;
            ++i;
        }
        this.addToList(xList, yList, indexList, prevX, maxY, prevIndex);
    }

    private boolean isInSameGridXAsPrevious(double x) {
        int xGridIndex = (int)((x - this.config.getXLowerValue()) / (this.config.getXUpperValue() - this.config.getXLowerValue()) * (double)this.config.getWidthInPixel());
        boolean isInSameGridAsPrevious = xGridIndex == this.previousXGridIndex;
        this.previousXGridIndex = xGridIndex;
        return isInSameGridAsPrevious;
    }
}

