/*
 * Decompiled with CFR 0.152.
 */
package org.swtchart.internal.series;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.swtchart.Chart;
import org.swtchart.IAxis;
import org.swtchart.IBarSeries;
import org.swtchart.ISeries;
import org.swtchart.Range;
import org.swtchart.internal.axis.Axis;
import org.swtchart.internal.compress.CompressBarSeries;
import org.swtchart.internal.compress.CompressScatterSeries;
import org.swtchart.internal.series.Series;

public class BarSeries
extends Series
implements IBarSeries {
    private int riserIndex;
    private Color barColor = Display.getDefault().getSystemColor(13);
    private int padding = 20;
    public static final int INITIAL_PADDING = 20;
    private static final int ALPHA = 208;
    private static final int MARGIN_AT_MIN_MAX_PLOT = 6;
    private static final int DEFAULT_BAR_COLOR = 13;

    protected BarSeries(Chart chart, String id) {
        super(chart, id);
        this.type = ISeries.SeriesType.BAR;
        this.compressor = new CompressBarSeries();
    }

    @Override
    public int getBarPadding() {
        return this.padding;
    }

    @Override
    public void setBarPadding(int padding) {
        if (padding < 0 || padding > 100) {
            SWT.error((int)5);
        }
        this.padding = padding;
    }

    @Override
    public Color getBarColor() {
        if (this.barColor.isDisposed()) {
            this.barColor = Display.getDefault().getSystemColor(13);
        }
        return this.barColor;
    }

    @Override
    public void setBarColor(Color color) {
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.barColor = color == null ? Display.getDefault().getSystemColor(13) : color;
    }

    @Override
    public Rectangle[] getBounds() {
        Rectangle[] compressedBounds = this.getBoundsForCompressedSeries();
        if (((Axis)this.chart.getAxisSet().getXAxis(this.xAxisId)).isValidCategoryAxis()) {
            return compressedBounds;
        }
        Rectangle[] rs = new Rectangle[this.xSeries.length];
        double[] comporessedXSeries = this.compressor.getCompressedXSeries();
        int cnt = 0;
        int i = 0;
        while (i < this.xSeries.length) {
            if (cnt < comporessedXSeries.length && comporessedXSeries[cnt] == this.xSeries[i]) {
                rs[i] = compressedBounds[cnt++];
            }
            ++i;
        }
        return rs;
    }

    private Rectangle[] getBoundsForCompressedSeries() {
        Axis xAxis = (Axis)this.chart.getAxisSet().getXAxis(this.xAxisId);
        Axis yAxis = (Axis)this.chart.getAxisSet().getYAxis(this.yAxisId);
        double[] xseries = this.compressor.getCompressedXSeries();
        double[] yseries = this.compressor.getCompressedYSeries();
        int[] indexes = this.compressor.getCompressedIndexes();
        if (xAxis.isValidCategoryAxis()) {
            int i = 0;
            while (i < xseries.length) {
                xseries[i] = indexes[i];
                ++i;
            }
        }
        Rectangle[] rectangles = new Rectangle[xseries.length];
        Range xRange = xAxis.getRange();
        Range yRange = yAxis.getRange();
        int i = 0;
        while (i < xseries.length) {
            int x = xAxis.getPixelCoordinate(xseries[i]);
            int y = yAxis.getPixelCoordinate(this.isValidStackSeries() ? this.stackSeries[indexes[i]] : yseries[i]);
            double baseYCoordinate = yAxis.getRange().lower > 0.0 ? yAxis.getRange().lower : 0.0;
            double riserwidth = this.getRiserWidth(xseries, i, xAxis, xRange.lower, xRange.upper);
            double riserHeight = Math.abs(yAxis.getPixelCoordinate(yseries[i], yRange.lower, yRange.upper) - yAxis.getPixelCoordinate(yAxis.isLogScaleEnabled() ? yRange.lower : baseYCoordinate, yRange.lower, yRange.upper));
            int riserCnt = xAxis.getNumRisers();
            if (riserCnt > 1) {
                x = xAxis.isHorizontalAxis() ? (int)((double)x - riserwidth / 2.0 + riserwidth / (double)riserCnt * ((double)this.riserIndex + 0.5)) : (int)((double)x - riserwidth / 2.0 + riserwidth / (double)riserCnt * ((double)(riserCnt - this.riserIndex) - 0.5));
                riserwidth /= (double)riserCnt;
            }
            if (xAxis.isHorizontalAxis()) {
                int width;
                if (y > yAxis.getPixelCoordinate(0.0)) {
                    y = yAxis.getPixelCoordinate(0.0);
                }
                width = (width = (int)Math.ceil(riserwidth)) == 0 ? 1 : width;
                rectangles[i] = this.getVisibleRectangle((int)Math.floor((double)x - riserwidth / 2.0), y, width, (int)riserHeight);
            } else {
                int height;
                if (y < yAxis.getPixelCoordinate(0.0)) {
                    y = yAxis.getPixelCoordinate(0.0);
                }
                height = (height = (int)Math.ceil(riserwidth)) == 0 ? 1 : height;
                rectangles[i] = this.getVisibleRectangle((int)((double)y - riserHeight), (int)Math.floor((double)x - riserwidth / 2.0), (int)riserHeight, height);
            }
            ++i;
        }
        return rectangles;
    }

    private Rectangle getVisibleRectangle(int x, int y, int width, int height) {
        int offset = 5;
        int newX = x;
        int newY = y;
        int newWidth = width;
        int newHeight = height;
        if (x < 0) {
            newX = -5;
            newWidth += x + 5;
        }
        if (y < 0) {
            newY = -5;
            newHeight += y + 5;
        }
        Point size = this.chart.getPlotArea().getSize();
        if (x + width > size.x) {
            newWidth -= x + width - size.x + 5;
        }
        if (y + height > size.y) {
            newHeight -= y + height - size.y + 5;
        }
        return new Rectangle(newX, newY, newWidth, newHeight);
    }

    protected void setRiserIndex(int riserIndex) {
        this.riserIndex = riserIndex;
    }

    @Override
    protected void setCompressor() {
        this.compressor = this.isXMonotoneIncreasing ? new CompressBarSeries() : new CompressScatterSeries();
    }

    @Override
    public Range getAdjustedRange(Axis axis, int length) {
        Range range;
        int upperPlotMargin;
        int lowerPlotMargin;
        if (axis.getDirection() == IAxis.Direction.X) {
            double lowerRiserWidth = this.getRiserWidth(this.xSeries, 0, axis, this.minX, this.maxX);
            double upperRiserWidth = this.getRiserWidth(this.xSeries, this.xSeries.length - 1, axis, this.minX, this.maxX);
            lowerPlotMargin = (int)(lowerRiserWidth / 2.0 + 6.0);
            upperPlotMargin = (int)(upperRiserWidth / 2.0 + 6.0);
            range = this.getXRange();
        } else {
            range = this.getYRange();
            if (range.upper < 0.0) {
                range.upper = 0.0;
            }
            if (range.lower > 0.0) {
                range.lower = axis.isLogScaleEnabled() ? this.minY : 0.0;
            }
            lowerPlotMargin = range.lower == 0.0 ? 0 : 6;
            upperPlotMargin = range.upper == 0.0 ? 0 : 6;
        }
        return this.getRangeWithMargin(lowerPlotMargin, upperPlotMargin, length, axis, range);
    }

    private int getRiserWidth(double[] series, int index, Axis xAxis, double min, double max) {
        double lower;
        double upper;
        if (series.length == 1) {
            upper = series[0] + 0.5;
            lower = series[0] - 0.5;
        } else if (index != series.length - 1 && (index == 0 || series[index + 1] - series[index] < series[index] - series[index - 1])) {
            upper = series[index + 1];
            lower = series[index];
        } else {
            upper = series[index];
            lower = series[index - 1];
        }
        int width = Math.abs(xAxis.getPixelCoordinate(upper, min, max) - xAxis.getPixelCoordinate(lower, min, max));
        width = (int)((double)width * ((double)(100 - this.padding) / 100.0));
        if (width == 0) {
            width = 1;
        }
        return width;
    }

    private Color getFrameColor(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        red = (int)((double)red * (red > 128 ? 0.8 : 1.2));
        green = (int)((double)green * (green > 128 ? 0.8 : 1.2));
        blue = (int)((double)blue * (blue > 128 ? 0.8 : 1.2));
        return new Color(color.getDevice(), red, green, blue);
    }

    @Override
    protected void draw(GC gc, int width, int height, Axis xAxis, Axis yAxis) {
        Rectangle[] rs = this.getBoundsForCompressedSeries();
        int i = 0;
        while (i < rs.length) {
            this.drawRiser(gc, rs[i].x, rs[i].y, rs[i].width, rs[i].height);
            ++i;
        }
        if (this.seriesLabel.isVisible() || this.xErrorBar.isVisible() || this.yErrorBar.isVisible()) {
            double[] yseries = this.compressor.getCompressedYSeries();
            int[] indexes = this.compressor.getCompressedIndexes();
            int i2 = 0;
            while (i2 < rs.length) {
                int v;
                int h;
                this.seriesLabel.draw(gc, rs[i2].x + rs[i2].width / 2, rs[i2].y + rs[i2].height / 2, yseries[i2], indexes[i2], 0x1000000);
                if (xAxis.isHorizontalAxis()) {
                    h = xAxis.getPixelCoordinate(this.xSeries[indexes[i2]]);
                    v = yAxis.getPixelCoordinate(this.ySeries[indexes[i2]]);
                } else {
                    v = xAxis.getPixelCoordinate(this.xSeries[indexes[i2]]);
                    h = yAxis.getPixelCoordinate(this.ySeries[indexes[i2]]);
                }
                this.xErrorBar.draw(gc, h, v, xAxis, indexes[i2]);
                this.yErrorBar.draw(gc, h, v, yAxis, indexes[i2]);
                ++i2;
            }
        }
    }

    private void drawRiser(GC gc, int h, int v, int width, int height) {
        int alpha = gc.getAlpha();
        gc.setAlpha(208);
        gc.setBackground(this.getBarColor());
        gc.fillRectangle(h, v, width, height);
        gc.setLineStyle(1);
        Color frameColor = this.getFrameColor(this.getBarColor());
        gc.setForeground(frameColor);
        gc.drawRectangle(h, v, width, height);
        frameColor.dispose();
        gc.setAlpha(alpha);
    }
}

