/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.dialogs.pages;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.client.snmp.SnmpTrap;
import org.netxms.ui.eclipse.eventmanager.widgets.EventSelector;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.snmp.dialogs.MibSelectionDialog;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class SnmpTrapGeneral
extends PreferencePage {
    private SnmpTrap trap;
    private Text description;
    private Text oid;
    private EventSelector event;
    private Text eventTag;
    private Button buttonSelect;

    public SnmpTrapGeneral(SnmpTrap trap) {
        super("General");
        this.noDefaultAndApplyButton();
        this.trap = trap;
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        Messages.get();
        this.description = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)300, (String)Messages.TrapConfigurationDialog_Description, (String)this.trap.getDescription(), (Object)"WidgetHelper::default_layout_data");
        Composite oidSelection = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        oidSelection.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        oidSelection.setLayoutData((Object)gd);
        Messages.get();
        this.oid = WidgetHelper.createLabeledText((Composite)oidSelection, (int)2048, (int)300, (String)Messages.TrapConfigurationDialog_TrapOID, (String)(this.trap.getObjectId() != null ? this.trap.getObjectId().toString() : ""), (Object)"WidgetHelper::default_layout_data");
        this.buttonSelect = new Button(oidSelection, 8);
        Messages.get();
        this.buttonSelect.setText(Messages.TrapConfigurationDialog_Select);
        gd = new GridData();
        gd.widthHint = 90;
        gd.verticalAlignment = 1024;
        this.buttonSelect.setLayoutData((Object)gd);
        this.buttonSelect.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                SnmpTrapGeneral.this.selectObjectId();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.event = new EventSelector(dialogArea, 0);
        Messages.get();
        this.event.setLabel(Messages.TrapConfigurationDialog_Event);
        this.event.setEventCode(this.trap.getEventCode());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.event.setLayoutData((Object)gd);
        Messages.get();
        this.eventTag = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)-1, (String)Messages.TrapConfigurationDialog_UserTag, (String)this.trap.getEventTag(), (Object)"WidgetHelper::default_layout_data");
        return dialogArea;
    }

    private void selectObjectId() {
        SnmpObjectId id;
        try {
            id = SnmpObjectId.parseSnmpObjectId((String)this.oid.getText());
        }
        catch (SnmpObjectIdFormatException e) {
            id = null;
        }
        MibSelectionDialog dlg = new MibSelectionDialog(this.getShell(), id, 0L);
        if (dlg.open() == 0) {
            this.oid.setText(dlg.getSelectedObjectId().toString());
            this.oid.setFocus();
        }
    }

    public boolean performOk() {
        if (this.isControlCreated()) {
            try {
                this.trap.setObjectId(SnmpObjectId.parseSnmpObjectId((String)this.oid.getText()));
            }
            catch (SnmpObjectIdFormatException e) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.TrapConfigurationDialog_Warning, (String)Messages.TrapConfigurationDialog_WarningInvalidOID);
                return false;
            }
            this.trap.setDescription(this.description.getText());
            this.trap.setEventCode(this.event.getEventCode());
            this.trap.setEventTag(this.eventTag.getText());
        }
        return super.performOk();
    }
}

