/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.views.helpers;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.SSHCredentials;
import org.netxms.client.snmp.SnmpUsmCredential;

public class NetworkCredentials {
    public static int NETWORK_CONFIG_GLOBAL = -1;
    public static int ALL_ZONES = -2;
    public static final int SNMP_COMMUNITIES = 1;
    public static final int SNMP_USM_CREDENTIALS = 2;
    public static final int SNMP_PORTS = 4;
    public static final int AGENT_SECRETS = 8;
    public static final int AGENT_PORTS = 16;
    public static final int SSH_CREDENTIALS = 32;
    public static final int SSH_PORTS = 64;
    public static final int EVERYTHING = 127;
    private Map<Integer, List<String>> communities = new HashMap<Integer, List<String>>();
    private Map<Integer, List<SnmpUsmCredential>> usmCredentials = new HashMap<Integer, List<SnmpUsmCredential>>();
    private Map<Integer, List<String>> sharedSecrets = new HashMap<Integer, List<String>>();
    private Map<Integer, List<SSHCredentials>> sshCredentials = new HashMap<Integer, List<SSHCredentials>>();
    private Map<Integer, List<Integer>> snmpPorts = new HashMap<Integer, List<Integer>>();
    private Map<Integer, List<Integer>> agentPorts = new HashMap<Integer, List<Integer>>();
    private Map<Integer, List<Integer>> sshPorts = new HashMap<Integer, List<Integer>>();
    private NXCSession session;
    private Map<Integer, Integer> changedConfig = new HashMap<Integer, Integer>();

    public NetworkCredentials(NXCSession session) {
        this.session = session;
    }

    public void load(int configId, int zoneUIN) throws NXCException, IOException {
        if ((configId & 1) != 0) {
            if (ALL_ZONES == zoneUIN) {
                this.communities = this.session.getSnmpCommunities();
            } else {
                this.communities.put(zoneUIN, this.session.getSnmpCommunities(zoneUIN));
            }
        }
        if ((configId & 2) != 0) {
            if (ALL_ZONES == zoneUIN) {
                this.usmCredentials = this.session.getSnmpUsmCredentials();
            } else {
                this.usmCredentials.put(zoneUIN, this.session.getSnmpUsmCredentials(zoneUIN));
            }
        }
        if ((configId & 4) != 0) {
            if (ALL_ZONES == zoneUIN) {
                this.snmpPorts = this.session.getWellKnownPorts("snmp");
            } else {
                this.snmpPorts.put(zoneUIN, this.session.getWellKnownPorts(zoneUIN, "snmp"));
            }
        }
        if ((configId & 8) != 0) {
            if (ALL_ZONES == zoneUIN) {
                this.sharedSecrets = this.session.getAgentSharedSecrets();
            } else {
                this.sharedSecrets.put(zoneUIN, this.session.getAgentSharedSecrets(zoneUIN));
            }
        }
        if ((configId & 0x10) != 0) {
            if (ALL_ZONES == zoneUIN) {
                this.agentPorts = this.session.getWellKnownPorts("agent");
            } else {
                this.agentPorts.put(zoneUIN, this.session.getWellKnownPorts(zoneUIN, "agent"));
            }
        }
        if ((configId & 0x20) != 0) {
            if (ALL_ZONES == zoneUIN) {
                this.sshCredentials = this.session.getSshCredentials();
            } else {
                this.sshCredentials.put(zoneUIN, this.session.getSshCredentials(zoneUIN));
            }
        }
        if ((configId & 0x40) != 0) {
            if (ALL_ZONES == zoneUIN) {
                this.sshPorts = this.session.getWellKnownPorts("ssh");
            } else {
                this.sshPorts.put(zoneUIN, this.session.getWellKnownPorts(zoneUIN, "ssh"));
            }
        }
    }

    public boolean isChanged(int type, int zoneUIN) {
        return (this.changedConfig.getOrDefault(zoneUIN, 0) & type) > 0;
    }

    public void save() throws NXCException, IOException {
        for (Map.Entry<Integer, Integer> value : this.changedConfig.entrySet()) {
            if ((value.getValue() & 1) <= 0) continue;
            this.session.updateSnmpCommunities(value.getKey().intValue(), this.communities.get(value.getKey()));
        }
        for (Map.Entry<Integer, Integer> value : this.changedConfig.entrySet()) {
            if ((value.getValue() & 2) <= 0) continue;
            this.session.updateSnmpUsmCredentials(value.getKey().intValue(), this.usmCredentials.get(value.getKey()));
        }
        for (Map.Entry<Integer, Integer> value : this.changedConfig.entrySet()) {
            if ((value.getValue() & 4) <= 0) continue;
            this.session.updateWellKnownPorts(value.getKey().intValue(), "snmp", this.snmpPorts.get(value.getKey()));
        }
        for (Map.Entry<Integer, Integer> value : this.changedConfig.entrySet()) {
            if ((value.getValue() & 8) <= 0) continue;
            this.session.updateAgentSharedSecrets(value.getKey().intValue(), this.sharedSecrets.get(value.getKey()));
        }
        for (Map.Entry<Integer, Integer> value : this.changedConfig.entrySet()) {
            if ((value.getValue() & 0x10) <= 0) continue;
            this.session.updateWellKnownPorts(value.getKey().intValue(), "agent", this.agentPorts.get(value.getKey()));
        }
        for (Map.Entry<Integer, Integer> value : this.changedConfig.entrySet()) {
            if ((value.getValue() & 0x20) <= 0) continue;
            this.session.updateSshCredentials(value.getKey().intValue(), this.sshCredentials.get(value.getKey()));
        }
        for (Map.Entry<Integer, Integer> value : this.changedConfig.entrySet()) {
            if ((value.getValue() & 0x40) <= 0) continue;
            this.session.updateWellKnownPorts(value.getKey().intValue(), "ssh", this.sshPorts.get(value.getKey()));
        }
        this.changedConfig.clear();
    }

    public void setConfigUpdate(int zoneUIN, int id) {
        this.changedConfig.put(zoneUIN, this.changedConfig.getOrDefault(zoneUIN, 0) | id);
    }

    public List<String> getCommunities(int zoneUIN) {
        ArrayList list = this.communities.get(zoneUIN);
        return list != null ? list : new ArrayList(0);
    }

    public void addCommunityString(String communityString, int zoneUIN) {
        List<String> list = this.communities.get(zoneUIN);
        if (list == null) {
            list = new ArrayList<String>();
            this.communities.put(zoneUIN, list);
        }
        list.add(communityString);
    }

    public List<Integer> getPorts(int type, int zoneUIN) {
        Map<Integer, List<Integer>> portMap = this.portMapFromType(type);
        ArrayList ports = portMap.get(zoneUIN);
        return ports != null ? ports : new ArrayList(0);
    }

    public void addPort(int type, Integer port, int zoneUIN) {
        Map<Integer, List<Integer>> portMap = this.portMapFromType(type);
        List<Integer> ports = portMap.get(zoneUIN);
        if (ports == null) {
            ports = new ArrayList<Integer>();
            portMap.put(zoneUIN, ports);
        }
        ports.add(port);
    }

    private Map<Integer, List<Integer>> portMapFromType(int type) {
        switch (type) {
            case 4: {
                return this.snmpPorts;
            }
            case 16: {
                return this.agentPorts;
            }
            case 64: {
                return this.sshPorts;
            }
        }
        throw new IllegalArgumentException("Unknown port type");
    }

    public List<SSHCredentials> getSshCredentials(int zoneUIN) {
        ArrayList credentials = this.sshCredentials.get(zoneUIN);
        return credentials != null ? credentials : new ArrayList(0);
    }

    public void addSshCredentials(SSHCredentials credential, int zoneUIN) {
        if (this.sshCredentials.containsKey(zoneUIN)) {
            this.sshCredentials.get(zoneUIN).add(credential);
        } else {
            ArrayList<SSHCredentials> list = new ArrayList<SSHCredentials>();
            list.add(credential);
            this.sshCredentials.put(zoneUIN, list);
        }
    }

    public List<SnmpUsmCredential> getUsmCredentials(int zoneUIN) {
        if (this.usmCredentials.containsKey(zoneUIN)) {
            return this.usmCredentials.get(zoneUIN);
        }
        return new ArrayList<SnmpUsmCredential>(0);
    }

    public void addUsmCredentials(SnmpUsmCredential credential, int zoneUIN) {
        if (this.usmCredentials.containsKey(zoneUIN)) {
            this.usmCredentials.get(zoneUIN).add(credential);
        } else {
            ArrayList<SnmpUsmCredential> list = new ArrayList<SnmpUsmCredential>();
            list.add(credential);
            this.usmCredentials.put(zoneUIN, list);
        }
    }

    public List<String> getSharedSecrets(int zoneUIN) {
        if (this.sharedSecrets.containsKey(zoneUIN)) {
            return this.sharedSecrets.get(zoneUIN);
        }
        return new ArrayList<String>();
    }

    public void addSharedSecret(String sharedSecret, int zoneUIN) {
        if (this.sharedSecrets.containsKey(zoneUIN)) {
            this.sharedSecrets.get(zoneUIN).add(sharedSecret);
        } else {
            ArrayList<String> list = new ArrayList<String>();
            list.add(sharedSecret);
            this.sharedSecrets.put(zoneUIN, list);
        }
    }
}

