/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.impl.EclipseLogger;

public class EclipseLoggerFactory
implements ILoggerFactory {
    private ConcurrentMap<String, Logger> loggerMap = new ConcurrentHashMap<String, Logger>();

    public Logger getLogger(String name) {
        Logger simpleLogger = (Logger)this.loggerMap.get(name);
        if (simpleLogger != null) {
            return simpleLogger;
        }
        EclipseLogger newInstance = new EclipseLogger(name);
        Logger oldInstance = this.loggerMap.putIfAbsent(name, (Logger)newInstance);
        return oldInstance == null ? newInstance : oldInstance;
    }
}

