/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.agentmanager.Messages;
import org.netxms.ui.eclipse.agentmanager.views.AgentConfigEditorView;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class OpenAgentConfig
implements IObjectActionDelegate {
    private IWorkbenchWindow window;
    private long nodeId;

    public void run(IAction action) {
        IViewReference vr = this.window.getActivePage().findViewReference("org.netxms.ui.eclipse.agentmanager.views.AgentConfigEditorView", Long.toString(this.nodeId));
        if (vr != null) {
            AgentConfigEditorView view = (AgentConfigEditorView)vr.getView(true);
            if (view != null) {
                this.window.getActivePage().activate((IWorkbenchPart)view);
            }
        } else {
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.OpenAgentConfig_GetConfig, null, "org.netxms.ui.eclipse.agentmanager", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    final String config = session.readAgentConfigurationFile(OpenAgentConfig.this.nodeId);
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AgentConfigEditorView view = (AgentConfigEditorView)(this).OpenAgentConfig.this.window.getActivePage().showView("org.netxms.ui.eclipse.agentmanager.views.AgentConfigEditorView", Long.toString((this).OpenAgentConfig.this.nodeId), 1);
                                view.setConfig(config);
                            }
                            catch (PartInitException e) {
                                Shell shell = (this).OpenAgentConfig.this.window.getShell();
                                Messages.get();
                                Messages.get();
                                MessageDialogHelper.openError((Shell)shell, (String)Messages.OpenAgentConfig_Error, (String)(String.valueOf(Messages.OpenAgentConfig_OpenErrorPrefix) + e.getLocalizedMessage()));
                            }
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.OpenAgentConfig_OpenError;
                }
            }.start();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (obj instanceof AbstractNode && ((AbstractNode)obj).hasAgent()) {
                action.setEnabled(true);
                this.nodeId = ((AbstractObject)obj).getObjectId();
            } else {
                action.setEnabled(false);
                this.nodeId = 0L;
            }
        } else {
            action.setEnabled(false);
            this.nodeId = 0L;
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.window = targetPart.getSite().getWorkbenchWindow();
    }
}

