/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.views.helpers;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;

public class EventTemplateLabelProvider
extends WorkbenchLabelProvider
implements ITableLabelProvider {
    boolean isDialog;

    public EventTemplateLabelProvider(boolean isDialog) {
        this.isDialog = isDialog;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return columnIndex == 0 ? this.getImage(element) : null;
    }

    public String getColumnText(Object element, int columnIndex) {
        EventTemplate eventTemplate = (EventTemplate)element;
        switch (columnIndex) {
            case 0: {
                return Long.toString(eventTemplate.getCode());
            }
            case 1: {
                return eventTemplate.getName();
            }
            case 2: {
                if (this.isDialog) {
                    return eventTemplate.getTagList();
                }
                return StatusDisplayInfo.getStatusText((Severity)eventTemplate.getSeverity());
            }
            case 3: {
                return EventTemplateLabelProvider.buildFlagString(eventTemplate);
            }
            case 4: {
                return eventTemplate.getMessage();
            }
            case 5: {
                return eventTemplate.getTagList();
            }
        }
        return null;
    }

    private static String buildFlagString(EventTemplate eventTemplate) {
        StringBuilder sb = new StringBuilder();
        if ((eventTemplate.getFlags() & 1) != 0) {
            sb.append("log");
        }
        if ((eventTemplate.getFlags() & 2) != 0) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("hide");
        }
        return sb.toString();
    }
}

