/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.widgets;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.SessionListener;
import org.netxms.client.SessionNotification;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.eventmanager.Activator;
import org.netxms.ui.eclipse.eventmanager.Messages;
import org.netxms.ui.eclipse.eventmanager.dialogs.EditEventTemplateDialog;
import org.netxms.ui.eclipse.eventmanager.dialogs.EventReferenceViewDialog;
import org.netxms.ui.eclipse.eventmanager.views.helpers.EventTemplateComparator;
import org.netxms.ui.eclipse.eventmanager.views.helpers.EventTemplateFilter;
import org.netxms.ui.eclipse.eventmanager.views.helpers.EventTemplateLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class EventTemplateList
extends Composite
implements SessionListener {
    public static final int COLUMN_CODE = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_SEVERITY = 2;
    public static final int COLUMN_FLAGS = 3;
    public static final int COLUMN_MESSAGE = 4;
    public static final int COLUMN_TAGS = 5;
    private HashMap<Integer, EventTemplate> eventTemplates;
    private SortableTableViewer viewer;
    private FilterText filterControl;
    private Action actionNew;
    private Action actionEdit;
    private Action actionDelete;
    private Action actionDuplicate;
    private Action actionFindReferences;
    private Action actionShowFilter;
    private Action actionRefresh;
    private NXCSession session;
    private EventTemplateFilter filter;
    private boolean filterEnabled;
    private ViewPart viewPart;

    public EventTemplateList(ViewPart viewPart, Composite parent, int style, String configPrefix) {
        this(parent, style, configPrefix, false);
        this.viewPart = viewPart;
    }

    public EventTemplateList(Composite parent, int style, final String configPrefix, boolean isDialog) {
        super(parent, style);
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.filterEnabled = isDialog ? true : settings.getBoolean(String.valueOf(configPrefix) + ".filterEnabled");
        this.session = ConsoleSharedData.getSession();
        parent.setLayout((Layout)new FormLayout());
        this.filterControl = new FilterText(parent, 0, null, !isDialog);
        this.filterControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EventTemplateList.this.onFilterModify();
            }
        });
        this.filterControl.setCloseAction(new Action(){

            public void run() {
                EventTemplateList.this.enableFilter(false);
            }
        });
        String[] stringArray = new String[6];
        Messages.get();
        stringArray[0] = Messages.EventConfigurator_ColCode;
        Messages.get();
        stringArray[1] = Messages.EventConfigurator_ColName;
        Messages.get();
        stringArray[2] = Messages.EventConfigurator_ColSeverity;
        Messages.get();
        stringArray[3] = Messages.EventConfigurator_ColFlags;
        Messages.get();
        stringArray[4] = Messages.EventConfigurator_ColMessage;
        Messages.get();
        stringArray[5] = Messages.EventConfigurator_ColTags;
        String[] names = stringArray;
        int[] widths = new int[]{70, 200, 90, 50, 400, 300};
        String[] stringArray2 = new String[3];
        Messages.get();
        stringArray2[0] = Messages.EventConfigurator_ColCode;
        Messages.get();
        stringArray2[1] = Messages.EventConfigurator_ColName;
        Messages.get();
        stringArray2[2] = Messages.EventConfigurator_ColTags;
        String[] dialogNames = stringArray2;
        int[] dialogWidths = new int[]{70, 200, 300};
        this.viewer = new SortableTableViewer(parent, isDialog ? dialogNames : names, isDialog ? dialogWidths : widths, 0, 128, 68354);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)settings, (String)configPrefix);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new EventTemplateLabelProvider(isDialog));
        this.viewer.setComparator((ViewerComparator)new EventTemplateComparator(isDialog));
        this.filter = new EventTemplateFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = event.getStructuredSelection();
                if (selection != null) {
                    EventTemplateList.this.actionEdit.setEnabled(selection.size() == 1);
                    EventTemplateList.this.actionDelete.setEnabled(selection.size() > 0);
                    EventTemplateList.this.actionFindReferences.setEnabled(selection.size() == 1);
                }
            }
        });
        this.viewer.getControl().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EventTemplateList.this.session.removeListener((SessionListener)EventTemplateList.this);
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)EventTemplateList.this.viewer, (IDialogSettings)settings, (String)configPrefix);
                settings.put(String.valueOf(configPrefix) + ".filterEnabled", EventTemplateList.this.filterEnabled);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterControl);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterControl.setLayoutData((Object)fd);
        if (this.viewPart != null) {
            this.activateContext();
        }
        this.createActions();
        this.createPopupMenu();
        this.refreshView();
        this.session.addListener((SessionListener)this);
        this.enableFilter(this.filterEnabled);
        if (this.filterEnabled) {
            this.filterControl.setFocus();
        }
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.viewPart.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.eventmanager.contexts.EventConfigurator");
        }
    }

    private void refreshView() {
        Messages.get();
        new ConsoleJob(Messages.EventConfigurator_OpenJob_Title, null, "org.netxms.ui.eclipse.eventmanager", null){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.EventConfigurator_OpenJob_Error;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                List list = EventTemplateList.this.session.getEventTemplates();
                this.runInUIThread(() -> {
                    EventTemplateList.this.eventTemplates = new HashMap(list.size());
                    for (EventTemplate t : list) {
                        EventTemplateList.this.eventTemplates.put(t.getCode(), t);
                    }
                    EventTemplateList.this.viewer.setInput((Object)EventTemplateList.this.eventTemplates.values().toArray());
                });
            }
        }.start();
    }

    public void notificationHandler(final SessionNotification n) {
        if (this.isDisposed()) {
            return;
        }
        switch (n.getCode()) {
            case 1013: {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EventTemplate old = EventTemplateList.this.eventTemplates.get((int)n.getSubCode());
                        if (old != null) {
                            old.setAll((EventTemplate)n.getObject());
                            EventTemplateList.this.viewer.refresh();
                        } else {
                            EventTemplateList.this.eventTemplates.put((int)n.getSubCode(), new EventTemplate((EventTemplate)n.getObject()));
                            EventTemplateList.this.viewer.setInput((Object)EventTemplateList.this.eventTemplates.values().toArray());
                        }
                    }
                });
                break;
            }
            case 1014: {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        EventTemplateList.this.eventTemplates.remove((int)n.getSubCode());
                        EventTemplateList.this.viewer.setInput((Object)EventTemplateList.this.eventTemplates.values().toArray());
                    }
                });
            }
        }
    }

    private void createActions() {
        Messages.get();
        this.actionNew = new Action(Messages.EventConfigurator_NewEvent, SharedIcons.ADD_OBJECT){

            public void run() {
                EventTemplateList.this.createNewEventTemplate();
            }
        };
        this.actionNew.setActionDefinitionId("org.netxms.ui.eclipse.eventmanager.commands.new_event_template");
        Messages.get();
        this.actionEdit = new Action(Messages.EventConfigurator_Properties, SharedIcons.EDIT){

            public void run() {
                EventTemplateList.this.editEventTemplate();
            }
        };
        this.actionEdit.setEnabled(false);
        Messages.get();
        this.actionDelete = new Action(Messages.EventConfigurator_Delete, SharedIcons.DELETE_OBJECT){

            public void run() {
                EventTemplateList.this.deleteEventTemplate();
            }
        };
        this.actionDelete.setEnabled(false);
        this.actionDuplicate = new Action("D&uplicate..."){

            public void run() {
                EventTemplateList.this.duplicateEventTemplate();
            }
        };
        this.actionFindReferences = new Action("Find &references..."){

            public void run() {
                EventTemplateList.this.findReferences();
            }
        };
        Messages.get();
        this.actionShowFilter = new Action(Messages.EventConfigurator_ShowFilter, 2){

            public void run() {
                EventTemplateList.this.enableFilter(EventTemplateList.this.actionShowFilter.isChecked());
            }
        };
        this.actionShowFilter.setImageDescriptor(SharedIcons.FILTER);
        this.actionShowFilter.setChecked(this.filterEnabled);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.eventmanager.commands.show_filter");
        if (this.viewPart != null) {
            IHandlerService handlerService = (IHandlerService)this.viewPart.getSite().getService(IHandlerService.class);
            this.actionNew.setActionDefinitionId("org.netxms.ui.eclipse.eventmanager.commands.new_event_template");
            handlerService.activateHandler(this.actionNew.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionNew));
            this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.eventmanager.commands.show_filter");
            handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionShowFilter));
            this.actionRefresh = new RefreshAction((IViewPart)this.viewPart){

                public void run() {
                    EventTemplateList.this.refreshView();
                }
            };
        } else {
            this.actionRefresh = new RefreshAction(){

                public void run() {
                    EventTemplateList.this.refreshView();
                }
            };
        }
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                EventTemplateList.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IContributionItem)new GroupMarker("additions"));
        mgr.add((IAction)this.actionNew);
        mgr.add((IAction)this.actionDuplicate);
        mgr.add((IAction)this.actionEdit);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.actionFindReferences);
    }

    protected void createNewEventTemplate() {
        EventTemplate tmpl = new EventTemplate(0);
        EditEventTemplateDialog dlg = new EditEventTemplateDialog(this.getShell().getShell(), tmpl, false);
        if (dlg.open() == 0) {
            this.modifyEventTemplate(tmpl);
        }
    }

    protected void duplicateEventTemplate() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        EventTemplate tmpl = new EventTemplate((EventTemplate)selection.getFirstElement());
        tmpl.setCode(0);
        tmpl.setName(String.valueOf(tmpl.getName()) + "_COPY");
        EditEventTemplateDialog dlg = new EditEventTemplateDialog(this.getShell().getShell(), tmpl, true);
        if (dlg.open() == 0) {
            this.modifyEventTemplate(tmpl);
        }
    }

    protected void modifyEventTemplate(final EventTemplate tmpl) {
        Messages.get();
        new ConsoleJob(Messages.EventConfigurator_UpdateJob_Title, null, "org.netxms.ui.eclipse.eventmanager", null){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.EventConfigurator_UpdateJob_Error;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                EventTemplateList.this.session.modifyEventObject(tmpl);
            }
        }.start();
    }

    protected void editEventTemplate() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        EventTemplate tmpl = new EventTemplate((EventTemplate)selection.getFirstElement());
        EditEventTemplateDialog dlg = new EditEventTemplateDialog(this.getShell().getShell(), tmpl, false);
        if (dlg.open() == 0) {
            this.modifyEventTemplate(tmpl);
        }
    }

    protected void deleteEventTemplate() {
        String string;
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() > 1) {
            Messages.get();
            string = Messages.EventConfigurator_DeleteConfirmation_Plural;
        } else {
            Messages.get();
            string = Messages.EventConfigurator_DeleteConfirmation_Singular;
        }
        String message = string;
        Shell shell = this.viewPart.getSite().getShell();
        Messages.get();
        if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.EventConfigurator_DeleteConfirmationTitle, (String)message)) {
            return;
        }
        final EventTemplate[] deleteList = new EventTemplate[selection.size()];
        int i = 0;
        for (Object o : selection.toList()) {
            deleteList[i++] = (EventTemplate)o;
        }
        Messages.get();
        new ConsoleJob(Messages.EventConfigurator_DeleteJob_Title, null, "org.netxms.ui.eclipse.eventmanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.EventConfigurator_DeleteJob_Error;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                boolean skipReferencesCheck = false;
                EventTemplate[] eventTemplateArray = deleteList;
                int n = deleteList.length;
                int n2 = 0;
                while (n2 < n) {
                    block7: {
                        EventTemplate e;
                        block6: {
                            List eventReferences;
                            e = eventTemplateArray[n2];
                            if (skipReferencesCheck || (eventReferences = EventTemplateList.this.session.getEventReferences((long)e.getCode())).isEmpty()) break block6;
                            final int[] result = new int[1];
                            this.getDisplay().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    EventReferenceViewDialog dlg = new EventReferenceViewDialog(EventTemplateList.this.getShell(), e.getName(), eventReferences, true, deleteList.length > 1);
                                    result[0] = dlg.open();
                                }
                            });
                            if (result[0] == 3 || result[0] == 1) break block7;
                            if (result[0] == 21) {
                                return;
                            }
                            if (result[0] == 4) {
                                skipReferencesCheck = true;
                            }
                        }
                        EventTemplateList.this.session.deleteEventTemplate((long)e.getCode());
                    }
                    ++n2;
                }
            }
        }.start();
    }

    private void findReferences() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.size() != 1) {
            return;
        }
        final long eventCode = ((EventTemplate)selection.getFirstElement()).getCode();
        final String eventName = ((EventTemplate)selection.getFirstElement()).getName();
        new ConsoleJob("Get event template references", null, "org.netxms.ui.eclipse.eventmanager"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List eventReferences = EventTemplateList.this.session.getEventReferences(eventCode);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (!eventReferences.isEmpty()) {
                            EventReferenceViewDialog dlg = new EventReferenceViewDialog(EventTemplateList.this.getShell(), eventName, eventReferences, false, false);
                            dlg.open();
                        } else {
                            MessageDialogHelper.openInformation((Shell)EventTemplateList.this.getShell(), (String)"Event References", (String)"No references found.");
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get event template references";
            }
        }.start();
    }

    private void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterControl.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.viewer.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterControl) : new FormAttachment(0, 0);
        this.viewer.getControl().getParent().layout();
        if (enable) {
            this.filterControl.setFocus();
        } else {
            this.filterControl.setText("");
            this.onFilterModify();
        }
        this.actionShowFilter.setChecked(enable);
    }

    private void onFilterModify() {
        this.filter.setFilterText(this.filterControl.getText());
        this.viewer.refresh();
    }

    public SortableTableViewer getViewer() {
        return this.viewer;
    }

    public Action getActionNewTemplate() {
        return this.actionNew;
    }

    public Action getActionEdit() {
        return this.actionEdit;
    }

    public Action getActionDelete() {
        return this.actionDelete;
    }

    public Action getActionShowFilter() {
        return this.actionShowFilter;
    }

    public Action getActionRefresh() {
        return this.actionRefresh;
    }
}

