/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.widgets.helpers;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.Severity;
import org.netxms.client.events.Event;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.eventmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class EventLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private static final Color FOREGROUND_COLOR_DARK = new Color((Device)Display.getCurrent(), 0, 0, 0);
    private static final Color FOREGROUND_COLOR_LIGHT = new Color((Device)Display.getCurrent(), 255, 255, 255);
    private static final Color[] FOREGROUND_COLORS = new Color[]{FOREGROUND_COLOR_LIGHT, FOREGROUND_COLOR_DARK, FOREGROUND_COLOR_DARK, FOREGROUND_COLOR_LIGHT, FOREGROUND_COLOR_LIGHT};
    private NXCSession session = ConsoleSharedData.getSession();
    private boolean showColor = true;
    private boolean showIcons = false;

    public Color getForeground(Object element) {
        return this.showColor ? FOREGROUND_COLORS[((Event)element).getSeverity().getValue()] : null;
    }

    public Color getBackground(Object element) {
        return this.showColor ? StatusDisplayInfo.getStatusColor((Severity)((Event)element).getSeverity()) : null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (this.showIcons && columnIndex == 0) {
            return StatusDisplayInfo.getStatusImage((Severity)((Event)element).getSeverity());
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Event event = (Event)element;
        switch (columnIndex) {
            case 0: {
                return RegionalSettings.getDateTimeFormat().format(event.getTimeStamp());
            }
            case 1: {
                String string;
                AbstractObject object = this.session.findObjectById(event.getSourceId());
                if (object != null) {
                    string = object.getObjectName();
                } else {
                    Messages.get();
                    string = Messages.EventLabelProvider_Unknown;
                }
                return string;
            }
            case 2: {
                return StatusDisplayInfo.getStatusText((Severity)event.getSeverity());
            }
            case 3: {
                return this.session.getEventName(event.getCode());
            }
            case 4: {
                return event.getMessage();
            }
        }
        return null;
    }

    public boolean isShowColor() {
        return this.showColor;
    }

    public void setShowColor(boolean showColor) {
        this.showColor = showColor;
    }

    public boolean isShowIcons() {
        return this.showIcons;
    }

    public void setShowIcons(boolean showIcons) {
        this.showIcons = showIcons;
    }
}

