/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.TableCell;
import org.netxms.client.TableColumnDefinition;
import org.netxms.client.TableRow;
import org.netxms.client.constants.DataOrigin;
import org.netxms.client.constants.DataType;

public class Table {
    private DataOrigin source;
    private String title;
    private List<TableColumnDefinition> columns;
    private List<TableRow> data;
    private boolean extendedFormat;

    public Table() {
        this.title = "untitled";
        this.source = DataOrigin.AGENT;
        this.columns = new ArrayList<TableColumnDefinition>(0);
        this.data = new ArrayList<TableRow>(0);
        this.extendedFormat = false;
    }

    public Table(NXCPMessage msg) {
        this.title = msg.getFieldAsString(168L);
        this.source = DataOrigin.getByValue(msg.getFieldAsInt32(46L));
        int columnCount = msg.getFieldAsInt32(329L);
        this.columns = new ArrayList<TableColumnDefinition>(columnCount);
        long varId = 0x10000000L;
        int i = 0;
        while (i < columnCount) {
            this.columns.add(new TableColumnDefinition(msg, varId));
            ++i;
            varId += 10L;
        }
        int totalRowCount = msg.getFieldAsInt32(328L);
        this.data = new ArrayList<TableRow>(totalRowCount);
        this.extendedFormat = msg.getFieldAsBoolean(466L);
        int rowCount = msg.getFieldAsInt32(167L);
        varId = 0x20000000L;
        int i2 = 0;
        while (i2 < rowCount) {
            TableRow row = new TableRow(columnCount);
            if (this.extendedFormat) {
                row.setObjectId(msg.getFieldAsInt64(varId++));
                if (msg.isFieldPresent(varId)) {
                    row.setBaseRow(msg.getFieldAsInt32(varId));
                }
                varId += 9L;
            }
            int j = 0;
            while (j < columnCount) {
                row.get(j).setValue(msg.getFieldAsString(varId++));
                if (this.extendedFormat) {
                    int status = msg.getFieldAsInt32(varId++);
                    row.get(j).setStatus(status == 65535 ? -1 : status);
                    row.get(j).setObjectId(msg.getFieldAsInt64(varId++));
                    varId += 7L;
                }
                ++j;
            }
            this.data.add(row);
            ++i2;
        }
    }

    public void addDataFromMessage(NXCPMessage msg) {
        int rowCount = msg.getFieldAsInt32(167L);
        long varId = 0x20000000L;
        int i = 0;
        while (i < rowCount) {
            TableRow row = new TableRow(this.columns.size());
            if (this.extendedFormat) {
                row.setObjectId(msg.getFieldAsInt64(varId++));
                if (msg.isFieldPresent(varId)) {
                    row.setBaseRow(msg.getFieldAsInt32(varId));
                }
                varId += 9L;
            }
            int j = 0;
            while (j < this.columns.size()) {
                row.get(j).setValue(msg.getFieldAsString(varId++));
                if (this.extendedFormat) {
                    int status = msg.getFieldAsInt32(varId++);
                    row.get(j).setStatus(status == 65535 ? -1 : status);
                    row.get(j).setObjectId(msg.getFieldAsInt64(varId++));
                    varId += 7L;
                }
                ++j;
            }
            this.data.add(row);
            ++i;
        }
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setField(168L, this.title);
        msg.setFieldInt16(466L, this.extendedFormat ? 1 : 0);
        msg.setFieldInt32(329L, this.columns.size());
        long varId = 0x10000000L;
        for (TableColumnDefinition c : this.columns) {
            c.fillMessage(msg, varId);
            varId += 10L;
        }
        msg.setFieldInt32(328L, this.data.size());
        varId = 0x20000000L;
        int i = 0;
        while (i < this.data.size()) {
            varId = this.data.get(i).fillMessage(msg, varId, this.extendedFormat);
            ++i;
        }
    }

    public void deleteAllRows() {
        this.data = new ArrayList<TableRow>(0);
    }

    public void sort(Comparator<TableRow> comparator) {
        Collections.sort(this.data, comparator);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public int getRowCount() {
        return this.data.size();
    }

    public TableColumnDefinition getColumnDefinition(int column) throws IndexOutOfBoundsException {
        return this.columns.get(column);
    }

    public String getColumnName(int column) throws IndexOutOfBoundsException {
        return this.columns.get(column).getName();
    }

    public String getColumnDisplayName(int column) throws IndexOutOfBoundsException {
        return this.columns.get(column).getDisplayName();
    }

    public int getColumnIndex(String name) {
        int i = 0;
        while (i < this.columns.size()) {
            if (this.columns.get(i).getName().equalsIgnoreCase(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public TableColumnDefinition[] getColumns() {
        return this.columns.toArray(new TableColumnDefinition[this.columns.size()]);
    }

    public String getCellValue(int row, int column) throws IndexOutOfBoundsException {
        return this.data.get(row).get(column).getValue();
    }

    public TableCell getCell(int row, int column) throws IndexOutOfBoundsException {
        return this.data.get(row).get(column);
    }

    public TableRow getRow(int row) throws IndexOutOfBoundsException {
        return this.data.get(row);
    }

    public TableRow[] getAllRows() {
        return this.data.toArray(new TableRow[this.data.size()]);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Table");
        sb.append("{columns=").append(this.columns);
        sb.append(", data=").append(this.data);
        sb.append('}');
        return sb.toString();
    }

    public void addAll(Table src) {
        for (TableRow r : src.data) {
            this.data.add(new TableRow(r));
        }
    }

    public void addRow() {
        this.data.add(new TableRow(this.columns.size()));
    }

    public void setCell(int row, int col, String value) {
        if (row >= 0 && row < this.data.size() && col >= 0 && col < this.columns.size()) {
            this.data.get(row).get(col).setValue(value);
        }
    }

    public DataOrigin getSource() {
        return this.source;
    }

    public void setSource(DataOrigin source) {
        this.source = source;
    }

    public String[] getColumnDisplayNames() {
        String[] names = new String[this.columns.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = this.columns.get(i).getDisplayName();
            ++i;
        }
        return names;
    }

    public DataType[] getColumnDataTypes() {
        DataType[] types = new DataType[this.columns.size()];
        int i = 0;
        while (i < types.length) {
            types[i] = this.columns.get(i).getDataType();
            ++i;
        }
        return types;
    }

    public boolean isExtendedFormat() {
        return this.extendedFormat;
    }

    public void setExtendedFormat(boolean extendedFormat) {
        this.extendedFormat = extendedFormat;
    }

    public Table getFirstRows(int count) {
        Table t = new Table();
        t.title = this.title;
        t.source = this.source;
        t.extendedFormat = this.extendedFormat;
        t.columns = new ArrayList<TableColumnDefinition>(this.columns);
        t.data = new ArrayList<TableRow>(count);
        int realCount = Math.min(count, this.data.size());
        int i = 0;
        while (i < realCount) {
            t.data.add(this.data.get(i));
            ++i;
        }
        return t;
    }
}

