/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum AgentCompressionMode {
    DEFAULT(0),
    ENABLED(1),
    DISABLED(2);

    private static Logger logger;
    private static Map<Integer, AgentCompressionMode> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(AgentCompressionMode.class);
        lookupTable = new HashMap<Integer, AgentCompressionMode>();
        AgentCompressionMode[] agentCompressionModeArray = AgentCompressionMode.values();
        int n = agentCompressionModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            AgentCompressionMode element = agentCompressionModeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private AgentCompressionMode(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static AgentCompressionMode getByValue(int value) {
        AgentCompressionMode element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return DEFAULT;
        }
        return element;
    }
}

