/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum LinkLayerDiscoveryProtocol {
    UNKNOWN(0),
    FDB(1),
    CDP(2),
    LLDP(3),
    NDP(4),
    EDP(5),
    STP(6),
    OTHER(7),
    MANUAL(8);

    private static Logger logger;
    private static Map<Integer, LinkLayerDiscoveryProtocol> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(LinkLayerDiscoveryProtocol.class);
        lookupTable = new HashMap<Integer, LinkLayerDiscoveryProtocol>();
        LinkLayerDiscoveryProtocol[] linkLayerDiscoveryProtocolArray = LinkLayerDiscoveryProtocol.values();
        int n = linkLayerDiscoveryProtocolArray.length;
        int n2 = 0;
        while (n2 < n) {
            LinkLayerDiscoveryProtocol element = linkLayerDiscoveryProtocolArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private LinkLayerDiscoveryProtocol(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static LinkLayerDiscoveryProtocol getByValue(int value) {
        LinkLayerDiscoveryProtocol element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return UNKNOWN;
        }
        return element;
    }
}

