/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.constants;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum PassiveRackElementType {
    PATCH_PANEL(0),
    FILLER_PANEL(1),
    ORGANISER(2),
    PDU(3);

    private static Logger logger;
    private static Map<Integer, PassiveRackElementType> lookupTable;
    private int value;

    static {
        logger = LoggerFactory.getLogger(PassiveRackElementType.class);
        lookupTable = new HashMap<Integer, PassiveRackElementType>();
        PassiveRackElementType[] passiveRackElementTypeArray = PassiveRackElementType.values();
        int n = passiveRackElementTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            PassiveRackElementType element = passiveRackElementTypeArray[n2];
            lookupTable.put(element.value, element);
            ++n2;
        }
    }

    private PassiveRackElementType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static PassiveRackElementType getByValue(int value) {
        PassiveRackElementType element = lookupTable.get(value);
        if (element == null) {
            logger.warn("Unknown element " + value);
            return FILLER_PANEL;
        }
        return element;
    }
}

