/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.WinPerfCounter;

public class WinPerfObject {
    private String name;
    private List<WinPerfCounter> counters;
    private List<String> instances;

    public static List<WinPerfObject> createListFromMessage(NXCPMessage msg) {
        int count = msg.getFieldAsInt32(138L);
        ArrayList<WinPerfObject> objects = new ArrayList<WinPerfObject>(count);
        long varId = 0x10000000L;
        int i = 0;
        while (i < count) {
            WinPerfObject o = new WinPerfObject(msg, varId);
            varId += (long)(o.counters.size() + o.instances.size() + 3);
            objects.add(o);
            ++i;
        }
        return objects;
    }

    public static List<WinPerfObject> createPlaceholderList(String text) {
        ArrayList<WinPerfObject> objects = new ArrayList<WinPerfObject>(1);
        objects.add(new WinPerfObject(text));
        return objects;
    }

    private WinPerfObject(NXCPMessage msg, long baseId) {
        this.name = msg.getFieldAsString(baseId);
        int count = msg.getFieldAsInt32(baseId + 1L);
        this.counters = new ArrayList<WinPerfCounter>(count);
        long varId = baseId + 3L;
        int i = 0;
        while (i < count) {
            this.counters.add(new WinPerfCounter(this, msg.getFieldAsString(varId++)));
            ++i;
        }
        count = msg.getFieldAsInt32(baseId + 2L);
        this.instances = new ArrayList<String>(count);
        i = 0;
        while (i < count) {
            this.instances.add(msg.getFieldAsString(varId++));
            ++i;
        }
    }

    private WinPerfObject(String name) {
        this.name = name;
        this.counters = new ArrayList<WinPerfCounter>(0);
        this.instances = new ArrayList<String>(0);
    }

    public String getName() {
        return this.name;
    }

    public WinPerfCounter[] getCounters() {
        return this.counters.toArray(new WinPerfCounter[this.counters.size()]);
    }

    public String[] getInstances() {
        return this.instances.toArray(new String[this.instances.size()]);
    }

    public boolean hasCounters() {
        return this.counters.size() > 0;
    }

    public boolean hasInstances() {
        return this.instances.size() > 0;
    }
}

