/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.configs.LinkConfig;
import org.netxms.client.maps.configs.MapLinkDataSource;

public class NetworkMapLink {
    public static final int AUTO_GENERATED = 1;
    public static final int EXCLUDE_FROM_AUTO_UPDATE = 2;
    public static final int NORMAL = 0;
    public static final int VPN = 1;
    public static final int MULTILINK = 2;
    public static final int AGENT_TUNEL = 3;
    public static final int AGENT_PROXY = 4;
    public static final int SSH_PROXY = 5;
    public static final int SNMP_PROXY = 6;
    public static final int ICMP_PROXY = 7;
    public static final int SENSOR_PROXY = 8;
    public static final int ZONE_PROXY = 9;
    public static final int ROUTING_DEFAULT = 0;
    public static final int ROUTING_DIRECT = 1;
    public static final int ROUTING_MANHATTAN = 2;
    public static final int ROUTING_BENDPOINTS = 3;
    public static final int COLOR_SOURCE_UNDEFINED = -1;
    public static final int COLOR_SOURCE_DEFAULT = 0;
    public static final int COLOR_SOURCE_OBJECT_STATUS = 1;
    public static final int COLOR_SOURCE_CUSTOM_COLOR = 2;
    public static final int COLOR_SOURCE_SCRIPT = 3;
    public static final int COLOR_SOURCE_LINK_UTILIZATION = 4;
    public static final int COLOR_SOURCE_INTERFACE_STATUS = 5;
    private long id;
    private String name;
    private int type;
    private long element1;
    private long element2;
    private long interfaceId1;
    private long interfaceId2;
    private String connectorName1;
    private String connectorName2;
    private int colorSource;
    private int color;
    private String colorProvider;
    private LinkConfig config = new LinkConfig();
    private int flags;
    private int duplicateCount = 0;
    private int position = 0;
    private long commonFirstElement = 0L;
    private boolean directionInverted = false;

    public NetworkMapLink(long id, String name, int type, long element1, long interfaceId1, long element2, long interfaceId2, String connectorName1, String connectorName2, MapLinkDataSource[] dciList, int flags) {
        this.id = id;
        this.name = name;
        this.type = type;
        this.element1 = element1;
        this.element2 = element2;
        this.interfaceId1 = interfaceId1;
        this.interfaceId2 = interfaceId2;
        this.connectorName1 = connectorName1;
        this.connectorName2 = connectorName2;
        this.flags = flags;
        this.colorSource = 0;
        this.color = 0;
        this.colorProvider = null;
        this.config.setDciList(dciList);
    }

    public NetworkMapLink(long id, String name, int type, long element1, long element2, String connectorName1, String connectorName2, int flags) {
        this(id, name, type, element1, 0L, element2, 0L, connectorName1, connectorName2, null, flags);
    }

    public NetworkMapLink(long id, int type, long element1, long element2) {
        this(id, "", type, element1, 0L, element2, 0L, "", "", null, 0);
    }

    public NetworkMapLink(NXCPMessage msg, long baseId) {
        this.id = msg.getFieldAsInt64(baseId);
        this.name = msg.getFieldAsString(baseId + 1L);
        this.type = msg.getFieldAsInt32(baseId + 2L);
        this.element1 = msg.getFieldAsInt64(baseId + 3L);
        this.element2 = msg.getFieldAsInt64(baseId + 4L);
        this.connectorName1 = msg.getFieldAsString(baseId + 5L);
        this.connectorName2 = msg.getFieldAsString(baseId + 6L);
        this.flags = msg.getFieldAsInt32(baseId + 7L);
        this.colorSource = msg.getFieldAsInt32(baseId + 8L);
        this.color = msg.getFieldAsInt32(baseId + 9L);
        this.colorProvider = msg.getFieldAsString(baseId + 10L);
        this.interfaceId1 = msg.getFieldAsInt64(baseId + 12L);
        this.interfaceId2 = msg.getFieldAsInt64(baseId + 13L);
        String json = msg.getFieldAsString(baseId + 11L);
        try {
            this.config = json != null && !json.isEmpty() ? (LinkConfig)new Gson().fromJson(json, LinkConfig.class) : new LinkConfig();
        }
        catch (Exception e) {
            this.config = new LinkConfig();
        }
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        msg.setFieldInt32(baseId, (int)this.id);
        msg.setField(baseId + 1L, this.name);
        msg.setFieldInt16(baseId + 2L, this.type);
        msg.setField(baseId + 3L, this.connectorName1);
        msg.setField(baseId + 4L, this.connectorName2);
        msg.setFieldInt32(baseId + 5L, (int)this.element1);
        msg.setFieldInt32(baseId + 6L, (int)this.element2);
        msg.setFieldInt32(baseId + 7L, this.flags);
        msg.setFieldInt16(baseId + 8L, this.colorSource);
        msg.setFieldInt32(baseId + 9L, this.color);
        msg.setField(baseId + 10L, this.colorProvider);
        msg.setFieldJson(baseId + 11L, (Object)this.config);
        msg.setFieldInt32(baseId + 12L, (int)this.interfaceId1);
        msg.setFieldInt32(baseId + 13L, (int)this.interfaceId2);
    }

    public long getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public long getElement1() {
        return this.element1;
    }

    public long getElement2() {
        return this.element2;
    }

    public String getConnectorName1() {
        return this.connectorName1;
    }

    public String getConnectorName2() {
        return this.connectorName2;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        if (this.isUnnamed()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            sb.append(this.name);
            sb.append(" (");
        }
        sb.append(this.connectorName1 != null && !this.connectorName1.isEmpty() ? this.connectorName1 : "<noname>");
        sb.append(" - ");
        sb.append(this.connectorName2 != null && !this.connectorName2.isEmpty() ? this.connectorName2 : "<noname>");
        if (this.name != null && !this.name.isEmpty()) {
            sb.append(')');
        }
        return sb.toString();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasConnectorName1() {
        return this.connectorName1 != null && !this.connectorName1.isEmpty();
    }

    public boolean hasConnectorName2() {
        return this.connectorName2 != null && !this.connectorName2.isEmpty();
    }

    public boolean isUnnamed() {
        return !(this.name != null && !this.name.isEmpty() || this.connectorName1 != null && !this.connectorName1.isEmpty() || this.connectorName2 != null && !this.connectorName2.isEmpty());
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getColorSource() {
        return this.colorSource;
    }

    public void setColorSource(int colorSource) {
        this.colorSource = colorSource;
    }

    public String getColorProvider() {
        return this.colorProvider != null ? this.colorProvider : "";
    }

    public void setColorProvider(String colorProvider) {
        this.colorProvider = colorProvider;
    }

    public List<Long> getStatusObjects() {
        return this.config.getObjectStatusList();
    }

    public void setStatusObjects(List<Long> statusObjects) {
        this.config.setObjectStatusList(statusObjects != null ? statusObjects : new ArrayList(0));
    }

    public int getRouting() {
        return this.config.getRouting();
    }

    public void setRouting(int routing) {
        this.config.setRouting(routing);
    }

    public long[] getBendPoints() {
        return this.config.getBendPoints();
    }

    public void setBendPoints(long[] bendPoints) {
        this.config.setBendPoints(bendPoints);
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isAutoGenerated() {
        return (this.flags & 1) != 0;
    }

    public boolean isExcludedFromAutomaticUpdate() {
        return (this.flags & 2) != 0;
    }

    public void setExcludedFromAutomaticUpdate(boolean exclude) {
        this.flags = exclude ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public boolean hasDciData() {
        MapLinkDataSource[] dciList = this.config.getDciList();
        return dciList != null && dciList.length > 0;
    }

    public MapLinkDataSource[] getDciList() {
        if (this.hasDciData()) {
            return this.config.getDciList();
        }
        return null;
    }

    public List<MapLinkDataSource> getDciAsList() {
        ArrayList<MapLinkDataSource> dciList = new ArrayList<MapLinkDataSource>();
        if (this.hasDciData()) {
            MapLinkDataSource[] mapLinkDataSourceArray = this.getDciList();
            int n = mapLinkDataSourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                MapLinkDataSource dci = mapLinkDataSourceArray[n2];
                dciList.add(new MapLinkDataSource(dci));
                ++n2;
            }
        }
        return dciList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConnectorName1(String connectorName1) {
        this.connectorName1 = connectorName1;
    }

    public void setConnectorName2(String connectorName2) {
        this.connectorName2 = connectorName2;
    }

    public void setDuplicateCount(int duplicateCount) {
        this.duplicateCount = duplicateCount;
    }

    public int getDuplicateCount() {
        return this.duplicateCount;
    }

    public void updatePosition() {
        ++this.position;
        ++this.duplicateCount;
    }

    public void resetPosition() {
        this.position = 0;
        this.duplicateCount = 0;
    }

    public int getPosition() {
        return this.position;
    }

    public LinkConfig getConfig() {
        return this.config;
    }

    public long getInterfaceId1() {
        return this.interfaceId1;
    }

    public void setInterfaceId1(long interfaceId1) {
        this.interfaceId1 = interfaceId1;
    }

    public long getInterfaceId2() {
        return this.interfaceId2;
    }

    public void setInterfaceId2(long interfaceId2) {
        this.interfaceId2 = interfaceId2;
    }

    public long getCommonFirstElement() {
        return this.commonFirstElement == 0L ? this.element1 : this.commonFirstElement;
    }

    public void setCommonFirstElement(long commonFirstElement) {
        this.commonFirstElement = commonFirstElement;
        this.directionInverted = commonFirstElement != this.element1;
    }

    public boolean isDirectionInverted() {
        return this.directionInverted;
    }

    public String toString() {
        return "NetworkMapLink [name=" + this.name + ", type=" + this.type + ", element1=" + this.element1 + ", element2=" + this.element2 + ", connectorName1=" + this.connectorName1 + ", connectorName2=" + this.connectorName2 + ", colorSource=" + this.colorSource + ", color=" + this.color + ", statusObject=" + this.config.getObjectStatusList() + ", routing=" + this.config.getRouting() + ", flags=" + this.flags + ", labelPosition=" + this.config.getLabelPosition() + "]";
    }
}

