/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.reporting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.netxms.base.NXCPMessage;
import org.netxms.client.reporting.ReportParameter;

public class ReportDefinition {
    private UUID id;
    private String name;
    private int numberOfColumns;
    private List<ReportParameter> parameters;
    private boolean valid;

    public ReportDefinition(UUID id, NXCPMessage msg) {
        this.id = id;
        this.name = msg.getFieldAsString(20L);
        this.numberOfColumns = msg.getFieldAsInt32(166L);
        int count = msg.getFieldAsInt32(111L);
        this.parameters = new ArrayList<ReportParameter>(count);
        long fieldId = 0x30000000L;
        int i = 0;
        while (i < count) {
            this.parameters.add(new ReportParameter(msg, fieldId));
            ++i;
            fieldId += 10L;
        }
        Collections.sort(this.parameters, (p1, p2) -> p1.getIndex() - p2.getIndex());
        this.valid = true;
    }

    public ReportDefinition(UUID id) {
        this.id = id;
        this.name = id.toString();
        this.numberOfColumns = 1;
        this.parameters = new ArrayList<ReportParameter>(0);
        this.valid = false;
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public List<ReportParameter> getParameters() {
        return this.parameters;
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        return "ReportDefinition [id=" + this.id + ", name=" + this.name + ", numberOfColumns=" + this.numberOfColumns + ", parameters=" + this.parameters + ", valid=" + this.valid + "]";
    }
}

