/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.snmp;

import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;

public class SnmpValue {
    private String name;
    private SnmpObjectId objectId;
    private int type;
    private String value;
    private byte[] rawValue;
    private long nodeId;

    public SnmpValue(String name, int type, String value, byte[] rawValue, long nodeId) {
        this.name = name;
        this.objectId = null;
        this.type = type;
        this.value = value;
        this.rawValue = rawValue;
        this.nodeId = nodeId;
    }

    public SnmpValue(SnmpObjectId objectId, int type, String value, byte[] rawValue, long nodeId) {
        this.name = objectId.toString();
        this.objectId = objectId;
        this.type = type;
        this.value = value;
        this.rawValue = rawValue;
        this.nodeId = nodeId;
    }

    public String getName() {
        return this.name;
    }

    public SnmpObjectId getObjectId() {
        if (this.objectId == null) {
            try {
                this.objectId = SnmpObjectId.parseSnmpObjectId(this.name);
            }
            catch (SnmpObjectIdFormatException e) {
                this.objectId = new SnmpObjectId();
            }
        }
        return this.objectId;
    }

    public int getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public byte[] getRawValue() {
        return this.rawValue;
    }

    public final long getNodeId() {
        return this.nodeId;
    }
}

