/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.core.widgets.custom;

import java.util.HashMap;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef4.zest.core.widgets.FigureSubgraph;
import org.eclipse.gef4.zest.layouts.algorithms.TreeLayoutObserver;
import org.eclipse.gef4.zest.layouts.interfaces.LayoutContext;
import org.eclipse.gef4.zest.layouts.interfaces.NodeLayout;
import org.eclipse.gef4.zest.layouts.interfaces.SubgraphLayout;
import org.eclipse.swt.graphics.Color;

public class TriangleSubgraph
extends FigureSubgraph {
    private static HashMap contextToTree = new HashMap();
    private TriangleParameters parameters;

    public TriangleSubgraph(NodeLayout[] nodes, LayoutContext context, TriangleParameters triangleParameters) {
        super(nodes, context);
        this.parameters = triangleParameters;
        if (contextToTree.get(context) == null) {
            TreeLayoutObserver treeLayoutObserver = new TreeLayoutObserver(context, null);
            treeLayoutObserver.addTreeListener(new TreeLayoutObserver.TreeListener(){

                protected void defaultHandle(TreeLayoutObserver.TreeNode changedNode) {
                    SubgraphLayout subgraph = changedNode.getNode().getSubgraph();
                    if (subgraph instanceof TriangleSubgraph) {
                        ((TriangleSubgraph)subgraph).updateFigure();
                    }
                }
            });
            contextToTree.put(context, treeLayoutObserver);
        }
    }

    @Override
    protected void createFigure() {
        this.figure = new IsoscelesTriangle();
        this.figure.setBackgroundColor(this.parameters.color);
        this.figure.setForegroundColor(this.parameters.color);
    }

    private double log(double value, double base) {
        return Math.log(value) / Math.log(base);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void updateFigure() {
        tree = (TreeLayoutObserver)TriangleSubgraph.contextToTree.get(this.context);
        subgraphRoot = tree.getTreeNode((NodeLayout)this.nodes.iterator().next());
        if (subgraphRoot != null) ** GOTO lbl6
        return;
lbl-1000:
        // 1 sources

        {
            subgraphRoot = subgraphRoot.getParent();
lbl6:
            // 2 sources

            ** while (this.nodes.contains((Object)subgraphRoot.getNode()))
        }
lbl7:
        // 1 sources

        superRoot = tree.getSuperRoot();
        triangleHeight = this.parameters.referenceHeight * (double)subgraphRoot.getHeight() / (double)superRoot.getHeight();
        numOfNodes = superRoot.getNumOfDescendants();
        numOfNodesWithChildren = numOfNodes - superRoot.getNumOfLeaves() + 1;
        logBase = numOfNodesWithChildren > 0 ? (double)numOfNodes / (double)numOfNodesWithChildren : 1.0;
        triangleBaseModifier = (this.parameters.referenceBase - 1.0) / this.log(superRoot.getNumOfLeaves(), logBase);
        triangleBase = this.parameters.referenceBase + triangleBaseModifier * this.log((double)subgraphRoot.getNumOfLeaves() / (double)superRoot.getNumOfLeaves(), logBase);
        if (this.parameters.direction == 0) {
            this.parameters.direction = this.parameters.direction;
        }
        if (this.parameters.direction == 1 || this.parameters.direction == 2) {
            this.figure.setSize((int)(triangleBase + 0.5), (int)(triangleHeight + 0.5));
        } else {
            this.figure.setSize((int)(triangleHeight + 0.5), (int)(triangleBase + 0.5));
        }
        numOfNodesWithChildrenInSubgraph = this.nodes.size() - subgraphRoot.getNumOfLeaves() + 1;
        avgNumOfChildrenInSugbraph = numOfNodesWithChildrenInSubgraph > 0 ? (double)this.nodes.size() / (double)numOfNodesWithChildrenInSubgraph : 1.0;
        r = (int)((double)this.parameters.color.getRed() + (255.0 - (double)this.parameters.color.getRed()) / avgNumOfChildrenInSugbraph);
        g = (int)((double)this.parameters.color.getGreen() + (255.0 - (double)this.parameters.color.getGreen()) / avgNumOfChildrenInSugbraph);
        b = (int)((double)this.parameters.color.getBlue() + (255.0 - (double)this.parameters.color.getBlue()) / avgNumOfChildrenInSugbraph);
        this.figure.setBackgroundColor(new Color(this.parameters.color.getDevice(), r, g, b));
        this.figure.setForegroundColor(this.parameters.color);
    }

    @Override
    public boolean isDirectionDependant() {
        return true;
    }

    @Override
    public void setDirection(int direction) {
        super.setDirection(direction);
        if (this.parameters.direction == direction) {
            return;
        }
        if (direction != 1 && direction != 2 && direction != 3 && direction != 4) {
            throw new IllegalArgumentException("invalid direction");
        }
        this.parameters.direction = direction;
        this.updateFigure();
    }

    public void setColor(Color color) {
        this.parameters.color = color;
        this.updateFigure();
    }

    private class IsoscelesTriangle
    extends Shape {
        private PointList points = new PointList(3);

        private IsoscelesTriangle() {
        }

        protected void fillShape(Graphics graphics) {
            graphics.fillPolygon(this.points);
        }

        protected void outlineShape(Graphics graphics) {
            graphics.drawPolygon(this.points);
        }

        protected void primTranslate(int dx, int dy) {
            super.primTranslate(dx, dy);
            this.points.translate(dx, dy);
        }

        public void validate() {
            super.validate();
            Rectangle r = new Rectangle();
            r.setBounds(this.getBounds());
            r.shrink(this.getInsets());
            this.points.removeAllPoints();
            switch (TriangleSubgraph.this.parameters.direction) {
                case 1: {
                    this.points.addPoint(r.x + r.width / 2, r.y);
                    this.points.addPoint(r.x, r.y + r.height);
                    this.points.addPoint(r.x + r.width, r.y + r.height);
                    break;
                }
                case 2: {
                    this.points.addPoint(r.x + r.width / 2, r.y + r.height);
                    this.points.addPoint(r.x, r.y);
                    this.points.addPoint(r.x + r.width, r.y);
                    break;
                }
                case 3: {
                    this.points.addPoint(r.x, r.y + r.height / 2);
                    this.points.addPoint(r.x + r.width, r.y);
                    this.points.addPoint(r.x + r.width, r.y + r.height);
                    break;
                }
                case 4: {
                    this.points.addPoint(r.x + r.width, r.y + r.height / 2);
                    this.points.addPoint(r.x, r.y);
                    this.points.addPoint(r.x, r.y + r.height);
                }
            }
        }
    }

    public static class TriangleParameters
    implements Cloneable {
        public Color color = ColorConstants.black;
        public int direction = 1;
        public double referenceHeight = 50.0;
        public double referenceBase = 50.0;

        public Object clone() {
            TriangleParameters result = new TriangleParameters();
            result.color = this.color;
            result.direction = this.direction;
            result.referenceHeight = this.referenceHeight;
            result.referenceBase = this.referenceBase;
            return result;
        }
    }
}

