/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.dialogs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciSummaryTable;
import org.netxms.ui.eclipse.dashboard.widgets.TableColumnSelector;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SortingColumnSelectionDialog
extends Dialog {
    private TableColumnSelector columnSelector;
    private Button checkDescending;
    private DciSummaryTable sourceSummaryTable;
    private int summaryTableId;
    private String columnName = "";
    private boolean descending;

    public SortingColumnSelectionDialog(Shell parentShell, String columnName, boolean descending, int summaryTableId) {
        super(parentShell);
        this.columnName = columnName;
        this.descending = descending;
        this.summaryTableId = summaryTableId;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Sorting Column");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        final NXCSession session = ConsoleSharedData.getSession();
        new ConsoleJob("Reading summary table configuration", null, "org.netxms.ui.eclipse.dashboard"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SortingColumnSelectionDialog.this.sourceSummaryTable = session.getDciSummaryTable(SortingColumnSelectionDialog.this.summaryTableId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).SortingColumnSelectionDialog.this.columnSelector.setSummaryTable((this).SortingColumnSelectionDialog.this.sourceSummaryTable);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Unable to get summary table configuration";
            }
        }.start();
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.columnSelector = new TableColumnSelector(dialogArea, 0, 8, this.columnName, null, this.sourceSummaryTable);
        this.columnSelector.setLabel("Column");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 500;
        this.columnSelector.setLayoutData(gd);
        this.checkDescending = new Button(dialogArea, 32);
        this.checkDescending.setText("Descending order");
        this.checkDescending.setSelection(this.descending);
        return dialogArea;
    }

    protected void okPressed() {
        this.columnName = String.valueOf(this.checkDescending.getSelection() ? ">" : "<") + this.columnSelector.getColumnName();
        super.okPressed();
    }

    public String getColumnName() {
        return this.columnName;
    }
}

