/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import com.google.gson.Gson;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.SyslogMonitorConfig;
import org.netxms.ui.eclipse.eventmanager.widgets.SyslogTraceWidget;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class SyslogMonitorElement
extends ElementWidget {
    private SyslogTraceWidget viewer;
    private SyslogMonitorConfig config;
    private final NXCSession session;

    protected SyslogMonitorElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, element, viewPart);
        try {
            this.config = (SyslogMonitorConfig)new Gson().fromJson(element.getData(), SyslogMonitorConfig.class);
        }
        catch (Exception e) {
            Activator.logError((String)"Cannot parse dashboard element configuration", (Throwable)e);
            this.config = new SyslogMonitorConfig();
        }
        this.processCommonSettings(this.config);
        this.session = ConsoleSharedData.getSession();
        new ConsoleJob(String.format("Subscribing to channel %s", "Core.Syslog"), (IWorkbenchPart)viewPart, "org.netxms.ui.eclipse.console", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SyslogMonitorElement.this.session.subscribe("Core.Syslog");
            }

            protected String getErrorMessage() {
                return String.format("Cannot subscribe to channel %s", "Core.Syslog");
            }
        }.start();
        this.viewer = new SyslogTraceWidget(this.getContentArea(), 0, viewPart);
        this.viewer.setRootObject(this.getEffectiveObjectId(this.config.getObjectId()));
        this.viewer.getViewer().getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SyslogMonitorElement.this.setSelectionProviderDelegate(SyslogMonitorElement.this.viewer.getSelectionProvider());
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SyslogMonitorElement.this.unsubscribe();
            }
        });
    }

    private void unsubscribe() {
        ConsoleJob job = new ConsoleJob(String.format("Unsuscribing from channel %s", "Core.Syslog"), null, "org.netxms.ui.eclipse.console", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SyslogMonitorElement.this.session.unsubscribe("Core.Syslog");
            }

            protected String getErrorMessage() {
                return String.format("Cannot unsubscribe from channel %s", "Core.Syslog");
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
        super.dispose();
    }
}

