/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.dialogs.helpers.InterfaceDciInfo;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateInterfaceDciDialog
extends Dialog {
    private static final String[] names;
    private static final String[] descriptions;
    private static final boolean[] DEFAULT_ENABLED;
    private Interface object;
    private InterfaceDciForm[] forms = new InterfaceDciForm[names.length];
    private Combo pollingScheduleTypeSelector;
    private LabeledText textInterval;
    private Combo retentionTypeSelector;
    private LabeledText textRetention;
    private int pollingScheduleType;
    private int pollingInterval;
    private int retentionType;
    private int retentionTime;
    private InterfaceDciInfo[] dciInfo;

    static {
        String[] stringArray = new String[8];
        Messages.get();
        stringArray[0] = Messages.CreateInterfaceDciDialog_InBytes;
        Messages.get();
        stringArray[1] = Messages.CreateInterfaceDciDialog_OutBytes;
        Messages.get();
        stringArray[2] = Messages.CreateInterfaceDciDialog_InBits;
        Messages.get();
        stringArray[3] = Messages.CreateInterfaceDciDialog_OutBits;
        Messages.get();
        stringArray[4] = Messages.CreateInterfaceDciDialog_InPackets;
        Messages.get();
        stringArray[5] = Messages.CreateInterfaceDciDialog_OutPackets;
        Messages.get();
        stringArray[6] = Messages.CreateInterfaceDciDialog_InErrors;
        Messages.get();
        stringArray[7] = Messages.CreateInterfaceDciDialog_OutErrors;
        names = stringArray;
        String[] stringArray2 = new String[8];
        Messages.get();
        stringArray2[0] = Messages.CreateInterfaceDciDialog_InBytesDescr;
        Messages.get();
        stringArray2[1] = Messages.CreateInterfaceDciDialog_OutBytesDescr;
        Messages.get();
        stringArray2[2] = Messages.CreateInterfaceDciDialog_InBitsDescr;
        Messages.get();
        stringArray2[3] = Messages.CreateInterfaceDciDialog_OutBitsDescr;
        Messages.get();
        stringArray2[4] = Messages.CreateInterfaceDciDialog_InPacketsDescr;
        Messages.get();
        stringArray2[5] = Messages.CreateInterfaceDciDialog_OutPacketsDescr;
        Messages.get();
        stringArray2[6] = Messages.CreateInterfaceDciDialog_InErrorsDescr;
        Messages.get();
        stringArray2[7] = Messages.CreateInterfaceDciDialog_OutErrorsDescr;
        descriptions = stringArray2;
        boolean[] blArray = new boolean[8];
        blArray[0] = true;
        blArray[1] = true;
        DEFAULT_ENABLED = blArray;
    }

    public CreateInterfaceDciDialog(Shell parentShell, Interface object) {
        super(parentShell);
        this.object = object;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.CreateInterfaceDciDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        int savedRetentionType;
        int savedPollingScheduleType;
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        boolean[] enabled = new boolean[DEFAULT_ENABLED.length];
        boolean[] delta = new boolean[DEFAULT_ENABLED.length];
        int i = 0;
        while (i < enabled.length) {
            String v = settings.get("CreateInterfaceDciDialog.enabled_" + i);
            enabled[i] = v != null ? Boolean.parseBoolean(v) : DEFAULT_ENABLED[i];
            v = settings.get("CreateInterfaceDciDialog.delta_" + i);
            delta[i] = v != null ? Boolean.parseBoolean(v) : true;
            ++i;
        }
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        Group dataGroup = new Group(dialogArea, 0);
        Messages.get();
        dataGroup.setText(Messages.CreateInterfaceDciDialog_Data);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        dataGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        dataGroup.setLayout((Layout)layout);
        int i2 = 0;
        while (i2 < names.length) {
            if (i2 > 0) {
                Label sep = new Label((Composite)dataGroup, 258);
                gd = new GridData();
                gd.horizontalAlignment = 4;
                gd.grabExcessHorizontalSpace = true;
                sep.setLayoutData((Object)gd);
            }
            this.forms[i2] = new InterfaceDciForm((Composite)dataGroup, names[i2], this.object != null ? descriptions[i2].replaceAll("@@ifName@@", this.object.getObjectName()) : descriptions[i2], enabled[i2], delta[i2]);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.forms[i2].setLayoutData(gd);
            ++i2;
        }
        Group optionsGroup = new Group(dialogArea, 0);
        Messages.get();
        optionsGroup.setText(Messages.CreateInterfaceDciDialog_Options);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        optionsGroup.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        optionsGroup.setLayout((Layout)layout);
        try {
            savedPollingScheduleType = settings.getInt("CreateInterfaceDciDialog.pollingScheduleType");
        }
        catch (NumberFormatException e) {
            savedPollingScheduleType = 0;
        }
        this.pollingScheduleTypeSelector = WidgetHelper.createLabeledCombo((Composite)optionsGroup, (int)2056, (String)"Polling interval", (Object)"WidgetHelper::default_layout_data");
        this.pollingScheduleTypeSelector.add("Default");
        this.pollingScheduleTypeSelector.add("Custom");
        this.pollingScheduleTypeSelector.select(savedPollingScheduleType);
        this.pollingScheduleTypeSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateInterfaceDciDialog.this.textInterval.setEnabled(CreateInterfaceDciDialog.this.pollingScheduleTypeSelector.getSelectionIndex() == 1);
            }
        });
        try {
            savedRetentionType = settings.getInt("CreateInterfaceDciDialog.retentionType");
        }
        catch (NumberFormatException e) {
            savedRetentionType = 0;
        }
        this.retentionTypeSelector = WidgetHelper.createLabeledCombo((Composite)optionsGroup, (int)2056, (String)"Retention time", (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.retentionTypeSelector.add(Messages.General_UseDefaultRetention);
        Messages.get();
        this.retentionTypeSelector.add(Messages.General_UseCustomRetention);
        Messages.get();
        this.retentionTypeSelector.add(Messages.General_NoStorage);
        this.retentionTypeSelector.select(savedRetentionType);
        this.retentionTypeSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CreateInterfaceDciDialog.this.textRetention.setEnabled(CreateInterfaceDciDialog.this.retentionTypeSelector.getSelectionIndex() == 1);
            }
        });
        this.textInterval = new LabeledText((Composite)optionsGroup, 0);
        this.textInterval.setLabel("Custom polling interval (seconds)");
        String v = settings.get("CreateInterfaceDciDialog.pollingInterval");
        this.textInterval.setText(v != null ? v : "60");
        this.textInterval.getTextControl().setTextLimit(5);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textInterval.setLayoutData((Object)gd);
        this.textInterval.setEnabled(false);
        this.textRetention = new LabeledText((Composite)optionsGroup, 0);
        this.textRetention.setLabel("Custom retention time (days)");
        v = settings.get("CreateInterfaceDciDialog.retentionTime");
        this.textRetention.setText(v != null ? v : "30");
        this.textRetention.getTextControl().setTextLimit(5);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textRetention.setLayoutData((Object)gd);
        this.textRetention.setEnabled(false);
        return dialogArea;
    }

    protected void okPressed() {
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.pollingScheduleType = this.pollingScheduleTypeSelector.getSelectionIndex();
        try {
            this.pollingInterval = Integer.parseInt(this.textInterval.getText());
            if (this.pollingInterval < 2 || this.pollingInterval > 10000) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            if (this.pollingScheduleType == 1) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.CreateInterfaceDciDialog_Error, (String)Messages.CreateInterfaceDciDialog_BadPollingInterval);
            }
            this.pollingInterval = 60;
        }
        this.retentionType = this.retentionTypeSelector.getSelectionIndex();
        try {
            this.retentionTime = Integer.parseInt(this.textRetention.getText());
            if (this.retentionTime < 1 || this.retentionTime > 10000) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException e) {
            if (this.retentionType == 1) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.CreateInterfaceDciDialog_Error, (String)Messages.CreateInterfaceDciDialog_BadRetentionTime);
            }
            this.retentionTime = 30;
        }
        settings.put("CreateInterfaceDciDialog.pollingScheduleType", this.pollingScheduleType);
        settings.put("CreateInterfaceDciDialog.pollingInterval", this.pollingInterval);
        settings.put("CreateInterfaceDciDialog.retentionType", this.retentionType);
        settings.put("CreateInterfaceDciDialog.retentionTime", this.retentionTime);
        this.dciInfo = new InterfaceDciInfo[this.forms.length];
        int i = 0;
        while (i < this.forms.length) {
            this.dciInfo[i] = new InterfaceDciInfo(this.forms[i].isDciEnabled(), this.forms[i].isDelta(), this.forms[i].getDescription());
            settings.put("CreateInterfaceDciDialog.enabled_" + i, this.forms[i].isDciEnabled());
            settings.put("CreateInterfaceDciDialog.delta_" + i, this.forms[i].isDelta());
            settings.put("CreateInterfaceDciDialog.description_" + i, this.forms[i].getDescription());
            ++i;
        }
        super.okPressed();
    }

    public int getPollingScheduleType() {
        return this.pollingScheduleType;
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    public int getRetentionType() {
        return this.retentionType;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public InterfaceDciInfo[] getDciInfo() {
        return this.dciInfo;
    }

    private class InterfaceDciForm
    extends Composite {
        private Button checkEnable;
        private Button checkDelta;
        private Text description;

        public InterfaceDciForm(Composite parent, String name, String defaultDescription, boolean enabled, boolean delta) {
            super(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.setLayout((Layout)layout);
            Composite buttonRow = new Composite((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            buttonRow.setLayout((Layout)layout);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            buttonRow.setLayoutData((Object)gd);
            this.checkEnable = new Button(buttonRow, 32);
            this.checkEnable.setText(name);
            this.checkEnable.setSelection(enabled);
            this.checkDelta = new Button(buttonRow, 32);
            Messages.get();
            this.checkDelta.setText(Messages.CreateInterfaceDciDialog_Delta);
            this.checkDelta.setSelection(delta);
            this.checkDelta.setEnabled(enabled);
            gd = new GridData();
            gd.horizontalAlignment = 131072;
            this.checkDelta.setLayoutData((Object)gd);
            Composite textRow = new Composite((Composite)this, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            textRow.setLayout((Layout)layout);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            textRow.setLayoutData((Object)gd);
            Label label = new Label(textRow, 0);
            Messages.get();
            label.setText(Messages.CreateInterfaceDciDialog_Description);
            this.description = new Text(textRow, 2048);
            this.description.setText(defaultDescription);
            this.description.setTextLimit(255);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.description.setLayoutData((Object)gd);
            this.description.setEnabled(enabled);
            this.checkEnable.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = InterfaceDciForm.this.checkEnable.getSelection();
                    InterfaceDciForm.this.checkDelta.setEnabled(enabled);
                    InterfaceDciForm.this.description.setEnabled(enabled);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }

        public boolean isDciEnabled() {
            return this.checkEnable.getSelection();
        }

        public boolean isDelta() {
            return this.checkDelta.getSelection();
        }

        public String getDescription() {
            return this.description.getText();
        }
    }
}

