/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciValue;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.datacollection.Activator;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.datacollection.widgets.internal.DciListComparator;
import org.netxms.ui.eclipse.datacollection.widgets.internal.DciListFilter;
import org.netxms.ui.eclipse.datacollection.widgets.internal.DciListLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class DciList
extends Composite {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_PARAMETER = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    private boolean filterEnabled = true;
    private DciListFilter filter;
    private FilterText filterText;
    private final ViewPart viewPart;
    private AbstractObject node;
    private NXCSession session = ConsoleSharedData.getSession();
    private SortableTableViewer viewer;
    private int dcObjectType;
    private boolean allowNoValueObjects = false;

    public DciList(ViewPart viewPart, Composite parent, int style, AbstractNode _node, final String configPrefix, int dcObjectType, int selectionType, boolean allowNoValueObjects) {
        super(parent, style);
        this.viewPart = viewPart;
        this.node = _node;
        this.dcObjectType = dcObjectType;
        this.allowNoValueObjects = allowNoValueObjects;
        FormLayout formLayout = new FormLayout();
        this.setLayout((Layout)formLayout);
        this.filterText = new FilterText((Composite)this, 0, null, false);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DciList.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                DciList.this.enableFilter(false);
            }
        });
        final IDialogSettings ds = Activator.getDefault().getDialogSettings();
        String[] stringArray = new String[3];
        Messages.get();
        stringArray[0] = Messages.DciList_ColID;
        Messages.get();
        stringArray[1] = Messages.DciList_ColParam;
        Messages.get();
        stringArray[2] = Messages.DciList_ColDescr;
        String[] names = stringArray;
        int[] widths = new int[]{70, 150, 250};
        this.viewer = new SortableTableViewer((Composite)this, names, widths, 2, 1024, selectionType | 0x10000);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DciListLabelProvider());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new DciListComparator());
        this.filter = new DciListFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)ds, (String)configPrefix);
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)DciList.this.viewer, (IDialogSettings)ds, (String)configPrefix);
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        if (this.filterEnabled) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.getDataFromServer();
    }

    private void getDataFromServer() {
        if (this.node == null) {
            this.viewer.setInput((Object)new DciValue[0]);
            return;
        }
        Messages.get();
        ConsoleJob job = new ConsoleJob(String.format(Messages.DciList_JobTitle, this.node.getObjectName()), (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.datacollection", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.DciList_JobError, DciList.this.node.getObjectName());
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                List<DciValue> data;
                List<DciValue> list = data = DciList.this.dcObjectType == -1 ? Arrays.asList(DciList.this.session.getDataCollectionSummary(DciList.this.node.getObjectId(), false, false, DciList.this.allowNoValueObjects)) : new ArrayList<DciValue>(Arrays.asList(DciList.this.session.getDataCollectionSummary(DciList.this.node.getObjectId(), false, false, DciList.this.allowNoValueObjects)));
                if (DciList.this.dcObjectType != -1) {
                    Iterator<DciValue> it = data.iterator();
                    while (it.hasNext()) {
                        DciValue dci = it.next();
                        if (dci.getDcObjectType() == DciList.this.dcObjectType) continue;
                        it.remove();
                    }
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).DciList.this.viewer.setInput((Object)data.toArray());
                    }
                });
            }
        };
        job.setUser(false);
        job.start();
    }

    public void setNode(AbstractObject node) {
        this.node = node;
        this.getDataFromServer();
    }

    public void refresh() {
        this.getDataFromServer();
    }

    public List<DciValue> getSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        return new ArrayList<DciValue>(selection.toList());
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public void setDcObjectType(int dcObjectType) {
        this.dcObjectType = dcObjectType;
        this.getDataFromServer();
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.viewer.addDoubleClickListener(listener);
    }

    public void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.viewer.getControl().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.setFilter("");
        }
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    public void setFilter(String text) {
        this.filterText.setText(text);
        this.onFilterModify();
    }

    public String getFilter() {
        return this.filterText.getText();
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }
}

