/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.widgets.helpers;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserMetric;
import org.netxms.ui.eclipse.datacollection.widgets.helpers.LogParserRuleEditor;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.DashboardComposite;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class LogParserMetricEditor
extends DashboardComposite {
    private LogParserMetric metric;
    private LogParserRuleEditor editor;
    private LabeledText labelMetricName;
    private Button checkPush;
    private Spinner pushGroup;

    public LogParserMetricEditor(Composite parent, LogParserMetric metric, final LogParserRuleEditor editor) {
        super(parent, 2048);
        this.metric = metric;
        this.editor = editor;
        this.setBackground(parent.getBackground());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        this.setLayout((Layout)layout);
        this.labelMetricName = new LabeledText((Composite)this, 0);
        this.labelMetricName.setLabel("Metric name");
        this.labelMetricName.setBackground(this.getBackground());
        this.labelMetricName.setText(metric.getMetric());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        this.labelMetricName.setLayoutData((Object)gd);
        this.labelMetricName.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                editor.fireModifyListeners();
            }
        });
        Composite controlBar = new Composite((Composite)this, 0);
        controlBar.setLayout((Layout)new RowLayout(256));
        gd = new GridData();
        gd.horizontalAlignment = 131072;
        controlBar.setLayoutData((Object)gd);
        this.fillControlBar(controlBar);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.verticalAlignment = 1024;
        this.pushGroup = WidgetHelper.createLabeledSpinner((Composite)this, (int)2048, (String)"Capture group used for data push", (int)1, (int)500, (Object)gd);
        this.pushGroup.setSelection(metric.getGroup().intValue());
        this.pushGroup.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                editor.fireModifyListeners();
            }
        });
        this.checkPush = new Button((Composite)this, 32);
        this.checkPush.setBackground(this.getBackground());
        this.checkPush.setText("&Push");
        this.checkPush.setSelection(metric.isPush());
        this.checkPush.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                editor.fireModifyListeners();
            }
        });
    }

    private void fillControlBar(Composite parent) {
        ImageHyperlink link = new ImageHyperlink(parent, 0);
        link.setImage(SharedIcons.IMG_DELETE_OBJECT);
        link.setToolTipText("Delete");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LogParserMetricEditor.this.editor.deleteMetric(LogParserMetricEditor.this.metric);
            }
        });
    }

    public void save() {
        this.metric.setGroup(this.pushGroup.getSelection());
        this.metric.setMetric(this.labelMetricName.getText());
        this.metric.setPush(this.checkPush.getSelection());
    }
}

