/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectbrowser.Activator;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectOpenHandler;

public class ObjectOpenHandlerRegistry {
    private List<OpenHandlerData> openHandlers = new ArrayList<OpenHandlerData>(0);

    public ObjectOpenHandlerRegistry() {
        this.registerOpenHandlers();
    }

    public boolean callOpenObjectHandler(AbstractObject object) {
        for (OpenHandlerData h : this.openHandlers) {
            if (h.enabledFor != null && !h.enabledFor.isInstance(object) || !h.handler.openObject(object)) continue;
            return true;
        }
        return false;
    }

    private void registerOpenHandlers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.objectbrowser.objectOpenHandlers");
        int i = 0;
        while (i < elements.length) {
            try {
                OpenHandlerData h = new OpenHandlerData();
                h.handler = (ObjectOpenHandler)elements[i].createExecutableExtension("class");
                h.priority = ObjectOpenHandlerRegistry.safeParseInt(elements[i].getAttribute("priority"));
                String className = elements[i].getAttribute("enabledFor");
                try {
                    h.enabledFor = className != null ? Class.forName(className) : null;
                }
                catch (Exception e) {
                    h.enabledFor = null;
                }
                this.openHandlers.add(h);
            }
            catch (CoreException e) {
                Activator.logError("Exception in registerOpenHandlers()", e);
            }
            ++i;
        }
        Collections.sort(this.openHandlers, new Comparator<OpenHandlerData>(){

            @Override
            public int compare(OpenHandlerData arg0, OpenHandlerData arg1) {
                return arg0.priority - arg1.priority;
            }
        });
    }

    private static int safeParseInt(String s) {
        if (s == null) {
            return 65535;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 65535;
        }
    }

    private class OpenHandlerData {
        ObjectOpenHandler handler;
        int priority;
        Class<?> enabledFor;

        private OpenHandlerData() {
        }
    }
}

