/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectbrowser.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.InputField;
import org.netxms.client.constants.InputFieldType;
import org.netxms.ui.eclipse.objectbrowser.Messages;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class InputFieldEditDialog
extends Dialog {
    private final String[] typeNames;
    private boolean create;
    private InputField field;
    private LabeledText name;
    private Combo type;
    private LabeledText displayName;
    private Button checkValidatePassword;

    public InputFieldEditDialog(Shell parentShell, boolean create, InputField field) {
        super(parentShell);
        String[] stringArray = new String[3];
        Messages.get();
        stringArray[0] = Messages.EditInputFieldDialog_Text;
        Messages.get();
        stringArray[1] = Messages.EditInputFieldDialog_Password;
        Messages.get();
        stringArray[2] = Messages.EditInputFieldDialog_Number;
        this.typeNames = stringArray;
        this.create = create;
        this.field = field;
    }

    protected void configureShell(Shell newShell) {
        String string;
        super.configureShell(newShell);
        if (this.create) {
            Messages.get();
            string = Messages.EditInputFieldDialog_AddInputField;
        } else {
            Messages.get();
            string = Messages.EditInputFieldDialog_EditInputField;
        }
        newShell.setText(string);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.name = new LabeledText(dialogArea, 0);
        Messages.get();
        this.name.setLabel(Messages.EditInputFieldDialog_Name);
        this.name.setText(this.field.getName());
        this.name.setEditable(this.create);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.name.setLayoutData((Object)gd);
        Messages.get();
        this.type = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)Messages.EditInputFieldDialog_Type, (Object)"WidgetHelper::default_layout_data");
        int i = 0;
        while (i < this.typeNames.length) {
            this.type.add(this.typeNames[i]);
            ++i;
        }
        this.type.select(this.field.getType().getValue());
        this.type.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputFieldEditDialog.this.checkValidatePassword.setVisible(InputFieldType.getByValue((int)InputFieldEditDialog.this.type.getSelectionIndex()) == InputFieldType.PASSWORD);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.displayName = new LabeledText(dialogArea, 0);
        Messages.get();
        this.displayName.setLabel(Messages.EditInputFieldDialog_DisplayName);
        this.displayName.setText(this.field.getDisplayName());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 350;
        this.displayName.setLayoutData((Object)gd);
        this.checkValidatePassword = new Button(dialogArea, 32);
        Messages.get();
        this.checkValidatePassword.setText(Messages.EditInputFieldDialog_ValidatePassword);
        this.checkValidatePassword.setVisible(this.field.getType() == InputFieldType.PASSWORD);
        this.checkValidatePassword.setSelection(this.field.isPasswordValidationNeeded());
        return dialogArea;
    }

    protected void okPressed() {
        if (this.create) {
            this.field.setName(this.name.getText());
        }
        this.field.setType(InputFieldType.getByValue((int)this.type.getSelectionIndex()));
        this.field.setDisplayName(this.displayName.getText());
        if (this.field.getType() == InputFieldType.PASSWORD) {
            int flags = this.field.getFlags();
            flags = this.checkValidatePassword.getSelection() ? (flags |= 1) : (flags &= 0xFFFFFFFE);
            this.field.setFlags(flags);
        }
        super.okPressed();
    }
}

