/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.NetworkService;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.Activator;
import org.netxms.ui.eclipse.objectview.objecttabs.NodeComponentViewerTab;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.NetworkServiceListComparator;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.NetworkServiceListLabelProvider;
import org.netxms.ui.eclipse.objectview.objecttabs.helpers.NetworkServiceTabFilter;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class NetworkServiceTab
extends NodeComponentViewerTab {
    public static final int COLUMN_ID = 0;
    public static final int COLUMN_NAME = 1;
    public static final int COLUMN_STATUS = 2;
    public static final int COLUMN_SERVICE_TYPE = 3;
    public static final int COLUMN_ADDRESS = 4;
    public static final int COLUMN_PORT = 5;
    public static final int COLUMN_REQUEST = 6;
    public static final int COLUMN_RESPONSE = 7;
    public static final int COLUMN_POLLER_NODE = 8;
    public static final int COLUMN_POLL_COUNT = 9;
    private NetworkServiceListLabelProvider labelProvider;

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IAction)this.actionExportToCsv);
        manager.add((IContributionItem)new Separator());
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.getViewPart().getSite(), (ISelectionProvider)this.viewer);
    }

    @Override
    public void refresh() {
        if (this.getObject() != null) {
            this.viewer.setInput((Object)this.getObject().getAllChildren(11).toArray());
        } else {
            this.viewer.setInput((Object)new NetworkService[0]);
        }
    }

    @Override
    protected void createViewer() {
        String[] names = new String[]{"Id", "Name", "Status", "Service type", "Address", "Port", "Request", "Response", "Poller node", "Poll count"};
        int[] widths = new int[]{60, 150, 80, 80, 80, 80, 200, 200, 200, 80};
        this.viewer = new SortableTableViewer(this.mainArea, names, widths, 1, 128, 65538);
        this.labelProvider = new NetworkServiceListLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator((ViewerComparator)new NetworkServiceListComparator(this.labelProvider));
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.filter = new NetworkServiceTabFilter(this.labelProvider);
        this.viewer.addFilter((ViewerFilter)this.filter);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"NetworkService.V1");
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)NetworkServiceTab.this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"NetworkService.V1");
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText, 0, 1024);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        this.viewer.getControl().setLayoutData((Object)fd);
    }

    @Override
    public String getFilterSettingName() {
        return "NetworkServiceTab.showFilter";
    }

    @Override
    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return object instanceof NetworkService;
    }
}

