/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.propertypages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventProcessingPolicyRule;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.epp.Messages;
import org.netxms.ui.eclipse.epp.widgets.RuleEditor;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ObjectSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.ElementLabelComparator;

public class RuleSourceObjects
extends PropertyPage {
    private NXCSession session;
    private RuleEditor editor;
    private EventProcessingPolicyRule rule;
    private TableViewer sourceViewer;
    private TableViewer excludeViewer;
    private Map<Long, AbstractObject> objects = new HashMap<Long, AbstractObject>();
    private Map<Long, AbstractObject> excludedObjects = new HashMap<Long, AbstractObject>();
    private Button addButtonSource;
    private Button deleteButtonSource;
    private Button addButtonExclusion;
    private Button deleteButtonExclusion;
    private Button checkInverted;

    protected Control createContents(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        this.editor = (RuleEditor)((Object)this.getElement().getAdapter(RuleEditor.class));
        this.rule = this.editor.getRule();
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkInverted = new Button(dialogArea, 32);
        Messages.get();
        this.checkInverted.setText(Messages.RuleSourceObjects_InvertRule);
        this.checkInverted.setSelection(this.rule.isSourceInverted());
        new Label(dialogArea, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sourceViewer = new TableViewer(dialogArea, 67586);
        this.sourceViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.sourceViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.sourceViewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.sourceViewer.getLabelProvider()));
        this.sourceViewer.getTable().setSortDirection(128);
        this.sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = RuleSourceObjects.this.sourceViewer.getStructuredSelection().size();
                RuleSourceObjects.this.deleteButtonSource.setEnabled(size > 0);
            }
        });
        for (AbstractObject o : this.session.findMultipleObjects((Collection)this.rule.getSources(), true)) {
            this.objects.put(o.getObjectId(), o);
        }
        this.sourceViewer.setInput((Object)this.objects.values().toArray());
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.sourceViewer.getControl().setLayoutData((Object)gridData);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButtonSource = new Button(buttons, 8);
        Messages.get();
        this.addButtonSource.setText(Messages.RuleSourceObjects_Add);
        this.addButtonSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleSourceObjects.this.addSourceObject();
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.addButtonSource.setLayoutData((Object)rd);
        this.deleteButtonSource = new Button(buttons, 8);
        Messages.get();
        this.deleteButtonSource.setText(Messages.RuleSourceObjects_Delete);
        this.deleteButtonSource.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleSourceObjects.this.deleteSourceObject();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.deleteButtonSource.setLayoutData((Object)rd);
        new Label(dialogArea, 258).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Label label = new Label(dialogArea, 0);
        label.setText("Exclusions:");
        this.excludeViewer = new TableViewer(dialogArea, 67586);
        this.excludeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.excludeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.excludeViewer.setComparator((ViewerComparator)new ElementLabelComparator((ILabelProvider)this.excludeViewer.getLabelProvider()));
        this.excludeViewer.getTable().setSortDirection(128);
        this.excludeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                int size = RuleSourceObjects.this.excludeViewer.getStructuredSelection().size();
                RuleSourceObjects.this.deleteButtonExclusion.setEnabled(size > 0);
            }
        });
        for (AbstractObject o : this.session.findMultipleObjects((Collection)this.rule.getSourceExclusions(), true)) {
            this.excludedObjects.put(o.getObjectId(), o);
        }
        this.excludeViewer.setInput((Object)this.excludedObjects.values().toArray());
        gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.heightHint = 0;
        this.excludeViewer.getControl().setLayoutData((Object)gridData);
        buttons = new Composite(dialogArea, 0);
        buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginLeft = 0;
        buttonLayout.marginRight = 0;
        buttons.setLayout((Layout)buttonLayout);
        gridData = new GridData();
        gridData.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gridData);
        this.addButtonExclusion = new Button(buttons, 8);
        Messages.get();
        this.addButtonExclusion.setText(Messages.RuleSourceObjects_Add);
        this.addButtonExclusion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleSourceObjects.this.addExclusionObject();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.addButtonExclusion.setLayoutData((Object)rd);
        this.deleteButtonExclusion = new Button(buttons, 8);
        Messages.get();
        this.deleteButtonExclusion.setText(Messages.RuleSourceObjects_Delete);
        this.deleteButtonExclusion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuleSourceObjects.this.deleteExclusionObject();
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.deleteButtonExclusion.setLayoutData((Object)rd);
        return dialogArea;
    }

    private void addSourceObject() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell());
        dlg.enableMultiSelection(true);
        if (dlg.open() == 0) {
            for (AbstractObject o : dlg.getSelectedObjects()) {
                this.objects.put(o.getObjectId(), o);
            }
        }
        this.sourceViewer.setInput((Object)this.objects.values().toArray());
    }

    private void deleteSourceObject() {
        IStructuredSelection selection = this.sourceViewer.getStructuredSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                AbstractObject o = (AbstractObject)it.next();
                this.objects.remove(o.getObjectId());
            }
            this.sourceViewer.setInput((Object)this.objects.values().toArray());
        }
    }

    private void addExclusionObject() {
        ObjectSelectionDialog dlg = new ObjectSelectionDialog(this.getShell());
        dlg.enableMultiSelection(true);
        if (dlg.open() == 0) {
            for (AbstractObject o : dlg.getSelectedObjects()) {
                this.excludedObjects.put(o.getObjectId(), o);
            }
        }
        this.excludeViewer.setInput((Object)this.excludedObjects.values().toArray());
    }

    private void deleteExclusionObject() {
        IStructuredSelection selection = this.excludeViewer.getStructuredSelection();
        Iterator it = selection.iterator();
        if (it.hasNext()) {
            while (it.hasNext()) {
                AbstractObject o = (AbstractObject)it.next();
                this.excludedObjects.remove(o.getObjectId());
            }
            this.excludeViewer.setInput((Object)this.excludedObjects.values().toArray());
        }
    }

    private void doApply() {
        int flags = this.rule.getFlags();
        flags = !(!this.checkInverted.getSelection() || this.objects.isEmpty() && this.excludedObjects.isEmpty()) ? (flags |= 2) : (flags &= 0xFFFFFFFD);
        this.rule.setFlags(flags);
        this.rule.setSources(new ArrayList<Long>(this.objects.keySet()));
        this.rule.setSourceExclusions(new ArrayList<Long>(this.excludedObjects.keySet()));
        this.editor.setModified(true);
    }

    protected void performApply() {
        this.doApply();
    }

    public boolean performOk() {
        this.doApply();
        return super.performOk();
    }
}

