/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.IProgressService;
import org.netxms.client.NXCSession;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.client.objecttools.ObjectToolDetails;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ObjectToolsAdapterFactory
implements IAdapterFactory {
    private static final Class[] supportedClasses = new Class[]{IWorkbenchAdapter.class, ObjectToolDetails.class};

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject.getClass() != ObjectTool.class) {
            return null;
        }
        if (adapterType == ObjectToolDetails.class) {
            long toolId = ((ObjectTool)adaptableObject).getId();
            ObjectToolDetails details = null;
            ToolDetailLoader job = new ToolDetailLoader(toolId, PlatformUI.getWorkbench().getDisplay());
            IProgressService service = PlatformUI.getWorkbench().getProgressService();
            try {
                service.busyCursorWhile((IRunnableWithProgress)job);
                details = job.getResult();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return details;
        }
        if (adapterType == IWorkbenchAdapter.class) {
            return new IWorkbenchAdapter(){

                public Object getParent(Object o) {
                    return null;
                }

                public String getLabel(Object o) {
                    return ((ObjectTool)o).getDisplayName();
                }

                public ImageDescriptor getImageDescriptor(Object object) {
                    return null;
                }

                public Object[] getChildren(Object o) {
                    return null;
                }
            };
        }
        return null;
    }

    public Class<?>[] getAdapterList() {
        return supportedClasses;
    }

    private final class ToolDetailLoader
    implements IRunnableWithProgress {
        private Display display;
        private final long toolId;
        private ObjectToolDetails result = null;
        private NXCSession session = ConsoleSharedData.getSession();

        private ToolDetailLoader(long toolId, Display display) {
            this.toolId = toolId;
            this.display = display;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.result = this.session.getObjectToolDetails(this.toolId);
            }
            catch (Exception e) {
                this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsAdapterFactory_Error, (String)String.format(Messages.ObjectToolsAdapterFactory_LoaderErrorText, e.getLocalizedMessage()));
                    }
                });
            }
        }

        public ObjectToolDetails getResult() {
            return this.result;
        }
    }
}

