/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.netxms.client.NXCSession;
import org.netxms.client.TcpProxy;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpPortForwarder {
    private static final Logger logger = LoggerFactory.getLogger(TcpPortForwarder.class);
    private Display display = null;
    private Shell parentShell = null;
    private NXCSession session;
    private long nodeId;
    private int remotePort;
    private ServerSocket listener;
    private int sessionId = 0;
    private Map<Integer, Session> sessions = new HashMap<Integer, Session>();
    private IOConsoleOutputStream consoleOutputStream = null;

    public TcpPortForwarder(NXCSession session, long nodeId, int remotePort, int listenerTimeout) throws IOException {
        this.session = session;
        this.nodeId = nodeId;
        this.remotePort = remotePort;
        this.listener = new ServerSocket(0);
        this.listener.setSoTimeout(listenerTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        final Object mutex = new Object();
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                logger.info("TCP port forwarder listening on port " + TcpPortForwarder.this.listener.getLocalPort());
                Object object = mutex;
                synchronized (object) {
                    mutex.notifyAll();
                }
                try {
                    try {
                        while (true) {
                            Socket socket = TcpPortForwarder.this.listener.accept();
                            try {
                                TcpProxy proxy = TcpPortForwarder.this.session.setupTcpProxy(TcpPortForwarder.this.nodeId, TcpPortForwarder.this.remotePort);
                                Session session = new Session(++TcpPortForwarder.this.sessionId, socket, proxy);
                                Map<Integer, Session> map = TcpPortForwarder.this.sessions;
                                synchronized (map) {
                                    TcpPortForwarder.this.sessions.put(session.getId(), session);
                                    continue;
                                }
                            }
                            catch (Exception e) {
                                String nodeName = TcpPortForwarder.this.session.getObjectName(TcpPortForwarder.this.nodeId);
                                logger.error("TCP port forwarder for node " + nodeName + " remote port " + TcpPortForwarder.this.remotePort + " session setup error", (Throwable)e);
                                String emsg = e.getLocalizedMessage();
                                String msg = String.format("TCP port forwarder for node %s remote port %d session setup error (%s)", nodeName, TcpPortForwarder.this.remotePort, emsg != null && !emsg.isEmpty() ? emsg : e.getClass().getCanonicalName());
                                if (TcpPortForwarder.this.consoleOutputStream != null) {
                                    TcpPortForwarder.this.consoleOutputStream.write("\n*** " + msg + " ***\n");
                                } else if (TcpPortForwarder.this.display != null) {
                                    TcpPortForwarder.this.display.asyncExec(() -> MessageDialogHelper.openError((Shell)TcpPortForwarder.this.parentShell, (String)"TCP Port Forwarding Error", (String)msg));
                                }
                                socket.close();
                                continue;
                            }
                            break;
                        }
                    }
                    catch (Exception e) {
                        logger.error("TCP port forwarder listener loop error", (Throwable)e);
                        try {
                            TcpPortForwarder.this.listener.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Throwable throwable) {
                    try {
                        TcpPortForwarder.this.listener.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }, "TcpForwarder");
        thread.setDaemon(true);
        Object object = mutex;
        synchronized (object) {
            thread.start();
            mutex.wait();
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        logger.debug("Closing TCP forwarder instance on port " + this.listener.getLocalPort());
        try {
            this.listener.close();
        }
        catch (Exception e) {
            logger.debug("Error closing listening socket", (Throwable)e);
        }
        Map<Integer, Session> map = this.sessions;
        synchronized (map) {
            for (Session s : this.sessions.values()) {
                s.close();
            }
            this.sessions.clear();
        }
    }

    public int getLocalPort() {
        return this.listener.getLocalPort();
    }

    public IOConsoleOutputStream getConsoleOutputStream() {
        return this.consoleOutputStream;
    }

    public void setConsoleOutputStream(IOConsoleOutputStream consoleOutputStream) {
        this.consoleOutputStream = consoleOutputStream;
    }

    public Display getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = display;
    }

    public Shell getParentShell() {
        return this.parentShell;
    }

    public void setParentShell(Shell parentShell) {
        this.parentShell = parentShell;
    }

    private class Session {
        private int id;
        private Socket socket;
        private TcpProxy proxy;
        private Thread socketReaderThread;
        private Thread proxyReaderThread;

        public Session(int id, Socket socket, TcpProxy proxy) {
            this.id = id;
            this.socket = socket;
            this.proxy = proxy;
            this.socketReaderThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    logger.info("Socket reader started");
                    Session.this.socketReader();
                }
            }, "Session-" + id + "-Socket");
            this.socketReaderThread.setDaemon(true);
            this.proxyReaderThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    logger.info("Proxy reader started");
                    Session.this.proxyReader();
                }
            }, "Session-" + id + "-Proxy");
            this.proxyReaderThread.setDaemon(true);
            this.socketReaderThread.start();
            this.proxyReaderThread.start();
        }

        public void close() {
            try {
                this.socket.shutdownInput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.socket.shutdownOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public int getId() {
            return this.id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void socketReader() {
            try {
                InputStream in = this.socket.getInputStream();
                byte[] buffer = new byte[32768];
                while (true) {
                    int bytes;
                    if ((bytes = in.read(buffer)) <= 0) {
                        logger.info("Exit code " + bytes + " while reading socket input stream");
                        break;
                    }
                    this.proxy.getOutputStream().write(buffer, 0, bytes);
                }
            }
            catch (Exception e) {
                logger.error("Socket reader exception", (Throwable)e);
            }
            this.proxy.close();
            logger.info("Waiting for proxy reader to stop");
            try {
                this.proxyReaderThread.join();
            }
            catch (InterruptedException e) {
                logger.error("Thread join exception", (Throwable)e);
            }
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.info("Socket reader terminated");
            Map<Integer, Session> map = TcpPortForwarder.this.sessions;
            synchronized (map) {
                TcpPortForwarder.this.sessions.remove(this.id);
            }
            this.socket = null;
            this.proxy = null;
        }

        private void proxyReader() {
            try {
                InputStream in = this.proxy.getInputStream();
                OutputStream out = this.socket.getOutputStream();
                byte[] buffer = new byte[32768];
                while (true) {
                    int bytes;
                    if ((bytes = in.read(buffer)) <= 0) {
                        logger.info("Exit code " + bytes + " while reading proxy input stream");
                        break;
                    }
                    out.write(buffer, 0, bytes);
                }
            }
            catch (Exception e) {
                logger.error("Proxy reader exception", (Throwable)e);
            }
            logger.info("Proxy reader requesting local socket closure");
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            logger.info("Proxy reader terminated");
        }
    }
}

