/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolsCache;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ObjectToolSelectionDialog
extends Dialog {
    private static final String CONFIG_PREFIX = "ObjectToolSelectionDialog";
    private TableViewer viewer;
    private ObjectTool tool;

    public ObjectToolSelectionDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Tool");
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("ObjectToolSelectionDialog.cx"), settings.getInt("ObjectToolSelectionDialog.cy"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 2048);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((ObjectTool)e1).getName().compareToIgnoreCase(((ObjectTool)e2).getName());
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((ObjectTool)element).getName();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ObjectToolSelectionDialog.this.okPressed();
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 500;
        gd.widthHint = 350;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.setInput((Object)ObjectToolsCache.getInstance().getTools());
        return dialogArea;
    }

    protected void okPressed() {
        if (this.viewer.getSelection().isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please select tool from the list");
            return;
        }
        this.tool = (ObjectTool)((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        super.okPressed();
    }

    public ObjectTool getTool() {
        return this.tool;
    }
}

