/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PartInitException;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Dashboard;
import org.netxms.client.objects.NetworkMap;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.networkmaps.api.ObjectDoubleClickHandler;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class ObjectDoubleClickHandlerRegistry {
    private IViewPart viewPart;
    private List<DoubleClickHandlerData> doubleClickHandlers = new ArrayList<DoubleClickHandlerData>(0);
    private boolean defaultHandlerEnabled = true;

    public ObjectDoubleClickHandlerRegistry(IViewPart viewPart) {
        this.viewPart = viewPart;
        this.registerDoubleClickHandlers();
    }

    public boolean handleDoubleClick(AbstractObject object) {
        for (DoubleClickHandlerData h : this.doubleClickHandlers) {
            if (h.enabledFor != null && !h.enabledFor.isInstance(object) || !h.handler.onDoubleClick(object, this.viewPart)) continue;
            return true;
        }
        if (this.defaultHandlerEnabled && object.getDrillDownObjectId() != 0L) {
            AbstractObject drillDownObject = ConsoleSharedData.getSession().findObjectById(object.getDrillDownObjectId());
            if (drillDownObject instanceof NetworkMap) {
                try {
                    this.viewPart.getSite().getPage().showView("org.netxms.ui.eclipse.networkmaps.views.PredefinedMap", Long.toString(drillDownObject.getObjectId()), 1);
                }
                catch (PartInitException e) {
                    Shell shell = this.viewPart.getSite().getShell();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.AbstractNetworkMapView_Error, (String)String.format("Cannot open drill-down object view: %s", e.getMessage()));
                }
            } else if (drillDownObject instanceof Dashboard) {
                try {
                    this.viewPart.getSite().getPage().showView("org.netxms.ui.eclipse.dashboard.views.DashboardView", Long.toString(drillDownObject.getObjectId()), 1);
                }
                catch (PartInitException e) {
                    Shell shell = this.viewPart.getSite().getShell();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.AbstractNetworkMapView_Error, (String)String.format("Cannot open drill-down object view: %s", e.getMessage()));
                }
            }
        }
        return false;
    }

    public boolean isDefaultHandlerEnabled() {
        return this.defaultHandlerEnabled;
    }

    public void setDefaultHandlerEnabled(boolean defaultHandlerEnabled) {
        this.defaultHandlerEnabled = defaultHandlerEnabled;
    }

    private void registerDoubleClickHandlers() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.networkmaps.objectDoubleClickHandlers");
        int i = 0;
        while (i < elements.length) {
            try {
                DoubleClickHandlerData h = new DoubleClickHandlerData();
                h.handler = (ObjectDoubleClickHandler)elements[i].createExecutableExtension("class");
                h.priority = ObjectDoubleClickHandlerRegistry.safeParseInt(elements[i].getAttribute("priority"));
                String className = elements[i].getAttribute("enabledFor");
                try {
                    h.enabledFor = className != null ? Class.forName(className) : null;
                }
                catch (Exception e) {
                    h.enabledFor = null;
                }
                this.doubleClickHandlers.add(h);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
        Collections.sort(this.doubleClickHandlers, new Comparator<DoubleClickHandlerData>(){

            @Override
            public int compare(DoubleClickHandlerData arg0, DoubleClickHandlerData arg1) {
                return arg0.priority - arg1.priority;
            }
        });
    }

    private static int safeParseInt(String string) {
        if (string == null) {
            return 65535;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return 65535;
        }
    }

    private class DoubleClickHandlerData {
        ObjectDoubleClickHandler handler;
        int priority;
        Class<?> enabledFor;

        private DoubleClickHandlerData() {
        }
    }
}

