/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.maps.configs.MapDataSource;
import org.netxms.ui.eclipse.datacollection.widgets.DciSelector;
import org.netxms.ui.eclipse.networkmaps.Messages;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class DataSourceEditDlg
extends Dialog {
    private MapDataSource dci;
    private DciSelector dciSelector;
    private LabeledText instance;
    private LabeledText dataColumn;
    private LabeledText formatString;

    public DataSourceEditDlg(Shell parentShell, MapDataSource dci) {
        super(parentShell);
        this.dci = dci;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.DataSourceEditDlg_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.dciSelector = new DciSelector(dialogArea, 0);
        Messages.get();
        this.dciSelector.setLabel(Messages.DataSourceEditDlg_DCI);
        this.dciSelector.setDciId(this.dci.getNodeId(), this.dci.getDciId());
        this.dciSelector.setDcObjectType(this.dci.getType());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        gd.horizontalSpan = 2;
        this.dciSelector.setLayoutData((Object)gd);
        this.formatString = new LabeledText(dialogArea, 0);
        Messages.get();
        this.formatString.setLabel(Messages.DataSourceEditDlg_FormatString);
        this.formatString.setText(this.dci.getFormatString());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.formatString.setLayoutData((Object)gd);
        if (this.dci.getType() == 2) {
            Group tableGroup = new Group(dialogArea, 0);
            Messages.get();
            tableGroup.setText(Messages.DataSourceEditDlg_TableCell);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            tableGroup.setLayoutData((Object)gd);
            layout = new GridLayout();
            tableGroup.setLayout((Layout)layout);
            this.dataColumn = new LabeledText((Composite)tableGroup, 0);
            Messages.get();
            this.dataColumn.setLabel(Messages.DataSourceEditDlg_DataColumn);
            this.dataColumn.setText(this.dci.getColumn());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.dataColumn.setLayoutData((Object)gd);
            this.instance = new LabeledText((Composite)tableGroup, 0);
            Messages.get();
            this.instance.setLabel(Messages.DataSourceEditDlg_Instance);
            this.instance.setText(this.dci.getInstance());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.instance.setLayoutData((Object)gd);
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.dci.setNodeId(this.dciSelector.getNodeId());
        this.dci.setDciId(this.dciSelector.getDciId());
        this.dci.setFormatString(this.formatString.getText());
        if (this.dci.getType() == 2) {
            this.dci.setColumn(this.dataColumn.getText().trim());
            this.dci.setInstance(this.instance.getText());
        }
        super.okPressed();
    }
}

