/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.topology.objecttabs;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scrollable;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Interface;
import org.netxms.client.objects.Node;
import org.netxms.ui.eclipse.objectbrowser.api.ObjectContextMenu;
import org.netxms.ui.eclipse.objectview.objecttabs.NodeComponentTab;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.topology.widgets.DeviceView;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortInfo;
import org.netxms.ui.eclipse.topology.widgets.helpers.PortSelectionListener;

public class Ports
extends NodeComponentTab
implements ISelectionProvider {
    private ScrolledComposite scroller;
    private DeviceView deviceView;
    private ISelection selection = new StructuredSelection();
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();

    protected void createTabContent(Composite parent) {
        super.createTabContent(parent);
        this.scroller = new ScrolledComposite(this.mainArea, 768);
        this.deviceView = new DeviceView((Composite)this.scroller, 0);
        this.deviceView.addSelectionListener(new PortSelectionListener(){

            @Override
            public void portSelected(PortInfo port) {
                Interface iface;
                Ports.this.selection = port != null ? ((iface = (Interface)Ports.this.session.findObjectById(port.getInterfaceObjectId(), Interface.class)) != null ? new StructuredSelection((Object)iface) : new StructuredSelection()) : new StructuredSelection();
                for (ISelectionChangedListener listener : Ports.this.selectionListeners) {
                    listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)Ports.this, Ports.this.selection));
                }
            }
        });
        this.mainArea.setBackground(this.deviceView.getBackground());
        this.scroller.setContent((Control)this.deviceView);
        this.scroller.setExpandVertical(true);
        this.scroller.setExpandHorizontal(true);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)512, (int)20);
        WidgetHelper.setScrollBarIncrement((Scrollable)this.scroller, (int)256, (int)20);
        this.scroller.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Ports.this.scroller.setMinSize(Ports.this.deviceView.computeSize(-1, -1));
            }
        });
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.bottom = new FormAttachment(100, 0);
        fd.right = new FormAttachment(100, 0);
        this.scroller.setLayoutData((Object)fd);
        this.createPopupMenu();
    }

    public void refresh() {
        this.deviceView.setNodeId(this.getObject() != null ? this.getObject().getObjectId() : 0L);
        this.scroller.setMinSize(this.deviceView.computeSize(-1, -1));
    }

    public boolean needRefreshOnObjectChange(AbstractObject object) {
        return object instanceof Interface && object.isDirectChildOf(this.deviceView.getNodeId());
    }

    public boolean showForObject(AbstractObject object) {
        return object instanceof Node ? ((Node)object).isBridge() : false;
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                Ports.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.deviceView);
        this.deviceView.setMenu(menu);
        this.getViewPart().getSite().registerContextMenu(menuMgr, (ISelectionProvider)this);
    }

    private void fillContextMenu(IMenuManager manager) {
        ObjectContextMenu.fill((IMenuManager)manager, (IShellProvider)this.getViewPart().getSite(), (ISelectionProvider)this);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
    }
}

