/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.slm.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.BaseBusinessService;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class ObjectAutoBind
extends PropertyPage {
    private BaseBusinessService businessService;
    private Button checkboxEnableBind;
    private Button checkboxEnableUnbind;
    private Combo thresholdCombo;
    private ScriptEditor filterSource;
    private boolean initialBind;
    private boolean initialUnbind;
    private String initialAutoBindFilter;
    private int initialStatusThreshold;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        this.businessService = (BaseBusinessService)this.getElement().getAdapter(BaseBusinessService.class);
        this.initialBind = this.businessService.isAutoBindEnabled();
        this.initialUnbind = this.businessService.isAutoUnbindEnabled();
        this.initialAutoBindFilter = this.businessService.getAutoBindFilter();
        this.initialAutoBindFilter = this.businessService.getAutoBindFilter();
        this.initialStatusThreshold = this.businessService.getObjectStatusThreshold();
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.checkboxEnableBind = new Button(dialogArea, 32);
        this.checkboxEnableBind.setText("Automatically add objects selected by filter to this business service as check");
        this.checkboxEnableBind.setSelection(this.businessService.isAutoBindEnabled());
        this.checkboxEnableBind.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (ObjectAutoBind.this.checkboxEnableBind.getSelection()) {
                    ObjectAutoBind.this.filterSource.setEnabled(true);
                    ObjectAutoBind.this.filterSource.setFocus();
                    ObjectAutoBind.this.checkboxEnableUnbind.setEnabled(true);
                    ObjectAutoBind.this.thresholdCombo.setEnabled(true);
                } else {
                    ObjectAutoBind.this.filterSource.setEnabled(false);
                    ObjectAutoBind.this.checkboxEnableUnbind.setEnabled(false);
                    ObjectAutoBind.this.thresholdCombo.setEnabled(false);
                }
            }
        });
        this.checkboxEnableUnbind = new Button(dialogArea, 32);
        this.checkboxEnableUnbind.setText("Automatically remove objects selected by filter from this business service");
        this.checkboxEnableUnbind.setSelection(this.businessService.isAutoUnbindEnabled());
        this.checkboxEnableUnbind.setEnabled(this.businessService.isAutoBindEnabled());
        this.thresholdCombo = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)8, (String)"Status Threashold", (Object)new GridData());
        this.thresholdCombo.add("Default");
        int i = 1;
        while (i <= 4) {
            this.thresholdCombo.add(StatusDisplayInfo.getStatusText((int)i));
            ++i;
        }
        this.thresholdCombo.select(this.businessService.getObjectStatusThreshold());
        Label label = new Label(dialogArea, 0);
        label.setText("Filtering script");
        GridData gd = new GridData();
        gd.verticalIndent = 5;
        label.setLayoutData((Object)gd);
        this.filterSource = new ScriptEditor(dialogArea, 2048, 768, true, "Variables:\r\n\t$node\t\tnode being tested (null if object is not a node).\r\n\t$object\t\tobject being tested.\r\n\t$service\tcurrent business service this check belongs to.\r\n\r\nReturn value: true to bind object to this business service, false to unbind, null to make no changes.");
        this.filterSource.setText(this.businessService.getAutoBindFilter());
        this.filterSource.setEnabled(this.businessService.isAutoBindEnabled());
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.filterSource.setLayoutData((Object)gd);
        return dialogArea;
    }

    private boolean applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        final boolean apply = this.checkboxEnableBind.getSelection();
        final boolean remove = this.checkboxEnableUnbind.getSelection();
        if (apply == this.initialBind && remove == this.initialUnbind && this.initialStatusThreshold == this.thresholdCombo.getSelectionIndex() && this.initialAutoBindFilter.equals(this.filterSource.getText())) {
            return true;
        }
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        final NXCObjectModificationData md = new NXCObjectModificationData(this.businessService.getObjectId());
        md.setAutoBindFilter(this.filterSource.getText());
        int flags = this.businessService.getAutoBindFlags();
        flags = apply ? flags | 1 : flags & 0xFFFFFFFE;
        flags = remove ? flags | 2 : flags & 0xFFFFFFFD;
        md.setAutoBindFlags(Integer.valueOf(flags));
        md.setObjectStatusThreshold(Integer.valueOf(this.thresholdCombo.getSelectionIndex()));
        new ConsoleJob("Update auto-bind filter", null, "org.netxms.ui.eclipse.slm"){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
                ObjectAutoBind.this.initialBind = apply;
                ObjectAutoBind.this.initialUnbind = remove;
                ObjectAutoBind.this.initialAutoBindFilter = md.getAutoBindFilter();
                ObjectAutoBind.this.initialStatusThreshold = md.getObjectStatusThreshold();
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            ObjectAutoBind.this.setValid(true);
                        }
                    });
                }
            }

            protected String getErrorMessage() {
                return "Cannot change business service objects automatic bind options";
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkboxEnableBind.setSelection(false);
        this.checkboxEnableUnbind.setSelection(false);
        this.filterSource.setText("");
    }
}

