/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.tools;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;

public class ComparatorHelper {
    public static int compareInetAddresses(InetAddress a1, InetAddress a2) {
        if (a1 == null) {
            return a2 == null ? 0 : -1;
        }
        if (a2 == null) {
            return 1;
        }
        if (a1 instanceof Inet4Address && a2 instanceof Inet6Address) {
            return -1;
        }
        if (a1 instanceof Inet6Address && a2 instanceof Inet4Address) {
            return 1;
        }
        byte[] b1 = a1.getAddress();
        byte[] b2 = a2.getAddress();
        int length = Math.min(b1.length, b2.length);
        int i = 0;
        while (i < length) {
            int n1 = b1[i] & 0xFF;
            int n2 = b2[i] & 0xFF;
            if (n1 < n2) {
                return -1;
            }
            if (n1 > n2) {
                return 1;
            }
            ++i;
        }
        return b1.length - b2.length;
    }
}

