/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CText;

public class AbstractSelector
extends Composite {
    public static final int USE_HYPERLINK = 1;
    public static final int HIDE_LABEL = 2;
    public static final int SHOW_CONTEXT_BUTTON = 4;
    public static final int SHOW_CLEAR_BUTTON = 8;
    public static final int EDITABLE_TEXT = 16;
    private Label label;
    private CText text;
    private Button buttonSelect;
    private Button buttonContext;
    private Button buttonClear;
    private ImageHyperlink linkSelect;
    private ImageHyperlink linkContext;
    private ImageHyperlink linkClear;
    private Action actionCopy;
    private Image imageContext = null;
    private Image scaledImage = null;
    private Set<ModifyListener> modifyListeners = new HashSet<ModifyListener>(0);

    public AbstractSelector(Composite parent, int style, int options) {
        super(parent, style);
        GridData gd;
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.horizontalSpacing = 2;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        if ((options & 4) != 0) {
            ++layout.numColumns;
        }
        if ((options & 8) != 0) {
            ++layout.numColumns;
        }
        this.setLayout((Layout)layout);
        if ((options & 2) == 0) {
            this.label = new Label((Composite)this, 0);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = layout.numColumns;
            this.label.setLayoutData((Object)gd);
        }
        this.text = new CText(this, 0x800 | ((options & 0x10) != 0 ? 0 : 8));
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 4;
        this.text.setLayoutData(gd);
        if ((options & 1) != 0) {
            this.linkSelect = new ImageHyperlink((Composite)this, 0);
            gd = new GridData();
            gd.heightHint = this.text.computeSize((int)-1, (int)-1).y;
            this.linkSelect.setLayoutData((Object)gd);
            this.linkSelect.setImage(SharedIcons.IMG_FIND);
            this.linkSelect.setToolTipText(this.getSelectionButtonToolTip());
            this.linkSelect.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    AbstractSelector.this.selectionButtonHandler();
                }
            });
            if ((options & 4) != 0) {
                this.imageContext = Activator.getImageDescriptor("icons/context.png").createImage();
                this.linkContext = new ImageHyperlink((Composite)this, 0);
                gd = new GridData();
                gd.heightHint = this.text.computeSize((int)-1, (int)-1).y;
                this.linkContext.setLayoutData((Object)gd);
                this.linkContext.setImage(this.imageContext);
                this.linkContext.setToolTipText(this.getContextButtonToolTip());
                this.linkContext.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        AbstractSelector.this.contextButtonHandler();
                    }
                });
            }
            if ((options & 8) != 0) {
                this.linkClear = new ImageHyperlink((Composite)this, 0);
                gd = new GridData();
                gd.heightHint = this.text.computeSize((int)-1, (int)-1).y;
                this.linkClear.setLayoutData((Object)gd);
                this.linkClear.setImage(SharedIcons.IMG_CLEAR);
                this.linkClear.setToolTipText(this.getClearButtonToolTip());
                this.linkClear.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        AbstractSelector.this.clearButtonHandler();
                    }
                });
            }
        } else {
            this.buttonSelect = new Button((Composite)this, 8);
            gd = new GridData();
            gd.heightHint = this.text.computeSize((int)-1, (int)-1).y;
            this.buttonSelect.setLayoutData((Object)gd);
            this.buttonSelect.setImage(SharedIcons.IMG_FIND);
            this.buttonSelect.setToolTipText(this.getSelectionButtonToolTip());
            this.buttonSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractSelector.this.selectionButtonHandler();
                }
            });
            if ((options & 4) != 0) {
                this.imageContext = Activator.getImageDescriptor("icons/context.png").createImage();
                this.buttonContext = new Button((Composite)this, 8);
                gd = new GridData();
                gd.heightHint = this.text.computeSize((int)-1, (int)-1).y;
                this.buttonContext.setLayoutData((Object)gd);
                this.buttonContext.setImage(this.imageContext);
                this.buttonContext.setToolTipText(this.getContextButtonToolTip());
                this.buttonContext.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AbstractSelector.this.contextButtonHandler();
                    }
                });
            }
            if ((options & 8) != 0) {
                this.buttonClear = new Button((Composite)this, 8);
                gd = new GridData();
                gd.heightHint = this.text.computeSize((int)-1, (int)-1).y;
                this.buttonClear.setLayoutData((Object)gd);
                this.buttonClear.setImage(SharedIcons.IMG_CLEAR);
                this.buttonClear.setToolTipText(this.getClearButtonToolTip());
                this.buttonClear.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AbstractSelector.this.clearButtonHandler();
                    }
                });
            }
        }
        this.createActions();
        this.createContextMenu();
        this.text.setToolTipText(this.getTextToolTip());
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractSelector.this.scaledImage != null) {
                    AbstractSelector.this.scaledImage.dispose();
                }
                if (AbstractSelector.this.imageContext != null) {
                    AbstractSelector.this.imageContext.dispose();
                }
            }
        });
    }

    private void createActions() {
        Messages.get();
        this.actionCopy = new Action(Messages.AbstractSelector_CopyToClipboard){

            public void run() {
                WidgetHelper.copyToClipboard(AbstractSelector.this.getText());
            }
        };
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AbstractSelector.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.text);
        this.text.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        mgr.add((IAction)this.actionCopy);
    }

    protected void selectionButtonHandler() {
    }

    protected void clearButtonHandler() {
    }

    protected void contextButtonHandler() {
    }

    protected String getSelectionButtonToolTip() {
        Messages.get();
        return Messages.AbstractSelector_Select;
    }

    protected String getClearButtonToolTip() {
        Messages.get();
        return Messages.AbstractSelector_ClearSelection;
    }

    protected String getContextButtonToolTip() {
        return "Context";
    }

    protected String getTextToolTip() {
        return null;
    }

    public void setLabel(String newLabel) {
        this.label.setText(newLabel);
    }

    public String getLabel() {
        return this.label.getText();
    }

    protected void setText(String newText) {
        this.text.setText(newText != null ? newText : "");
    }

    protected String getText() {
        return this.text.getText();
    }

    protected void setImage(Image image) {
        if (this.scaledImage != null) {
            this.scaledImage.dispose();
            this.scaledImage = null;
        }
        if (image != null) {
            Rectangle size = image.getBounds();
            if (size.width > 64 || size.height > 64) {
                this.scaledImage = new Image((Device)this.getDisplay(), image.getImageData().scaledTo(64, 64));
                this.text.setImage(this.scaledImage);
            } else {
                this.text.setImage(image);
            }
        } else {
            this.text.setImage(null);
        }
    }

    protected Image getImage() {
        return this.text.getImage();
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setBackground(color);
            ++n2;
        }
    }

    public void setEnabled(boolean enabled) {
        this.text.setEnabled(enabled);
        if (this.buttonSelect != null) {
            this.buttonSelect.setEnabled(enabled);
        }
        if (this.linkSelect != null) {
            this.linkSelect.setEnabled(enabled);
        }
        if (this.buttonContext != null) {
            this.buttonContext.setEnabled(enabled);
        }
        if (this.linkContext != null) {
            this.linkContext.setEnabled(enabled);
        }
        if (this.buttonClear != null) {
            this.buttonClear.setEnabled(enabled);
        }
        if (this.linkClear != null) {
            this.linkClear.setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }

    public void setSelectioEnabled(boolean enabled) {
        if (this.buttonSelect != null) {
            this.buttonSelect.setEnabled(enabled);
        }
        if (this.linkSelect != null) {
            this.linkSelect.setEnabled(enabled);
        }
    }

    public Control getTextControl() {
        return this.text;
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.modifyListeners.remove(listener);
    }

    protected void fireModifyListeners() {
        if (this.modifyListeners.isEmpty()) {
            return;
        }
        Event e = new Event();
        e.display = this.getDisplay();
        e.doit = true;
        e.widget = this;
        ModifyEvent me = new ModifyEvent(e);
        for (ModifyListener l : this.modifyListeners) {
            l.modifyText(me);
        }
    }
}

