/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.netxms.ui.eclipse.tools.ColorCache;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class DashboardComposite
extends Canvas
implements PaintListener {
    protected ColorCache colors = new ColorCache((Control)this);
    private Color borderOuterColor;
    private Color borderInnerColor;
    private Color backgroundColor;
    private boolean hasBorder = true;

    public DashboardComposite(Composite parent, int style) {
        super(parent, style & 0xFFFFF7FF);
        if (ColorConverter.isDarkColor(this.getDisplay().getSystemColor(22).getRGB())) {
            this.borderOuterColor = this.colors.create(110, 111, 115);
            this.borderInnerColor = this.colors.create(53, 53, 53);
        } else {
            this.borderOuterColor = this.colors.create(171, 173, 179);
            this.borderInnerColor = this.colors.create(255, 255, 255);
        }
        this.backgroundColor = this.getDisplay().getSystemColor(25);
        this.hasBorder = (style & 0x800) != 0;
        this.addPaintListener(this);
        this.setBackground(this.backgroundColor);
        this.setLayout((Layout)new FillLayout());
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle trim = super.computeTrim(x, y, width, height);
        if (this.hasBorder) {
            trim.x -= 2;
            trim.y -= 2;
            trim.width += 4;
            trim.height += 4;
        }
        return trim;
    }

    public Rectangle getClientArea() {
        Rectangle area = super.getClientArea();
        if (this.hasBorder) {
            area.x += 2;
            area.y += 2;
            area.width -= 4;
            area.height -= 4;
        }
        return area;
    }

    public int getBorderWidth() {
        return this.hasBorder ? 2 : 0;
    }

    public void paintControl(PaintEvent e) {
        if (!this.hasBorder) {
            return;
        }
        Point size = this.getSize();
        Rectangle rect = new Rectangle(0, 0, size.x, size.y);
        --rect.width;
        --rect.height;
        e.gc.setForeground(this.borderOuterColor);
        e.gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 2, 2);
        ++rect.x;
        ++rect.y;
        rect.width -= 2;
        rect.height -= 2;
        e.gc.setForeground(this.borderInnerColor);
        e.gc.drawRoundRectangle(rect.x, rect.y, rect.width, rect.height, 2, 2);
    }

    protected Rectangle getFullClientArea() {
        return super.getClientArea();
    }

    protected Color getBorderOuterColor() {
        return this.borderOuterColor;
    }

    protected Color getBorderInnerColor() {
        return this.borderInnerColor;
    }
}

