/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets;

import java.text.DateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ServerClock
extends Composite {
    private static final int REFRESH_TIME = 30000;
    private Label time;
    private boolean showText;
    private boolean showTimeZone;

    public ServerClock(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.time = new Label((Composite)this, 0);
        Messages.get();
        this.time.setToolTipText(Messages.ServerClock_Tooltip);
        FontData fd = this.time.getFont().getFontData()[0];
        fd.setStyle(1);
        final Font font = new Font((Device)this.time.getDisplay(), fd);
        this.time.setFont(font);
        this.time.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        this.createPopupMenu();
        Runnable timer = new Runnable(){

            @Override
            public void run() {
                if (ServerClock.this.time.isDisposed()) {
                    return;
                }
                ServerClock.this.time.getDisplay().timerExec(30000, (Runnable)this);
                ServerClock.this.updateTimeDisplay();
            }
        };
        timer.run();
    }

    private void createPopupMenu() {
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        this.showText = settings.getBoolean("ServerClock.showText");
        this.showTimeZone = settings.getBoolean("ServerClock.showTimeZone");
        Messages.get();
        Action actionShowText = new Action(Messages.ServerClock_OptionShowText, 2){

            public void run() {
                ServerClock.this.showText = this.isChecked();
                settings.put("ServerClock.showText", ServerClock.this.showText);
                ServerClock.this.updateTimeDisplay();
            }
        };
        actionShowText.setChecked(this.showText);
        Messages.get();
        Action actionShowTimeZone = new Action(Messages.ServerClock_OptionShowTimeZone, 2){

            public void run() {
                ServerClock.this.showTimeZone = this.isChecked();
                settings.put("ServerClock.showTimeZone", ServerClock.this.showTimeZone);
                ServerClock.this.updateTimeDisplay();
            }
        };
        actionShowTimeZone.setChecked(this.showTimeZone);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)actionShowText);
        menuManager.add((IAction)actionShowTimeZone);
        this.setMenu(menuManager.createContextMenu((Control)this));
        this.time.setMenu(menuManager.createContextMenu((Control)this.time));
    }

    private void updateTimeDisplay() {
        DateFormat df = RegionalSettings.getShortTimeFormat();
        NXCSession session = ConsoleSharedData.getSession();
        String tz = session.getServerTimeZone();
        df.setTimeZone(TimeZone.getTimeZone(tz.replaceAll("[A-Za-z]+([\\+\\-][0-9]+).*", "GMT$1")));
        StringBuilder sb = new StringBuilder();
        if (this.showText) {
            Messages.get();
            sb.append(Messages.ServerClock_ServerTime);
            sb.append(' ');
        }
        sb.append(df.format(new Date(session.getServerTime())));
        if (this.showTimeZone) {
            sb.append(' ');
            sb.append(tz);
        }
        this.time.setText(sb.toString());
        this.getParent().layout(true, true);
    }
}

