/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.widgets.ansi;

import org.eclipse.swt.graphics.RGB;

public class AnsiConsoleColorPalette {
    public static final String PALETTE_VGA = "paletteVGA";
    public static final String PALETTE_WINXP = "paletteXP";
    public static final String PALETTE_MAC = "paletteMac";
    public static final String PALETTE_PUTTY = "palettePuTTY";
    public static final String PALETTE_XTERM = "paletteXTerm";
    private static final RGB[] paletteVGA = new RGB[]{new RGB(0, 0, 0), new RGB(170, 0, 0), new RGB(0, 170, 0), new RGB(170, 85, 0), new RGB(0, 0, 170), new RGB(170, 0, 170), new RGB(0, 170, 170), new RGB(170, 170, 170), new RGB(85, 85, 85), new RGB(255, 85, 85), new RGB(85, 255, 85), new RGB(255, 255, 85), new RGB(85, 85, 255), new RGB(255, 85, 255), new RGB(85, 255, 255), new RGB(255, 255, 255)};
    private static final RGB[] paletteXP = new RGB[]{new RGB(0, 0, 0), new RGB(128, 0, 0), new RGB(0, 128, 0), new RGB(128, 128, 0), new RGB(0, 0, 128), new RGB(128, 0, 128), new RGB(0, 128, 128), new RGB(192, 192, 192), new RGB(128, 128, 128), new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(255, 255, 0), new RGB(0, 0, 255), new RGB(255, 0, 255), new RGB(0, 255, 255), new RGB(255, 255, 255)};
    private static final RGB[] paletteMac = new RGB[]{new RGB(0, 0, 0), new RGB(194, 54, 33), new RGB(37, 188, 36), new RGB(173, 173, 39), new RGB(73, 46, 225), new RGB(211, 56, 211), new RGB(51, 187, 200), new RGB(203, 204, 205), new RGB(129, 131, 131), new RGB(252, 57, 31), new RGB(49, 231, 34), new RGB(234, 236, 35), new RGB(88, 51, 255), new RGB(249, 53, 248), new RGB(20, 240, 240), new RGB(233, 235, 235)};
    private static final RGB[] palettePuTTY = new RGB[]{new RGB(0, 0, 0), new RGB(187, 0, 0), new RGB(0, 187, 0), new RGB(187, 187, 0), new RGB(0, 0, 187), new RGB(187, 0, 187), new RGB(0, 187, 187), new RGB(187, 187, 187), new RGB(85, 85, 85), new RGB(255, 85, 85), new RGB(85, 255, 85), new RGB(255, 255, 85), new RGB(85, 85, 255), new RGB(255, 85, 255), new RGB(85, 255, 255), new RGB(255, 255, 255)};
    private static final RGB[] paletteXTerm = new RGB[]{new RGB(0, 0, 0), new RGB(205, 0, 0), new RGB(0, 205, 0), new RGB(205, 205, 0), new RGB(0, 0, 238), new RGB(205, 0, 205), new RGB(0, 205, 205), new RGB(229, 229, 229), new RGB(127, 127, 127), new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(255, 255, 0), new RGB(92, 92, 255), new RGB(255, 0, 255), new RGB(0, 255, 255), new RGB(255, 255, 255)};
    private static RGB[] palette = paletteXP;
    private static String currentPaletteName = "paletteXP";

    static int safe256(int value, int modulo) {
        int result = value * 256 / modulo;
        return result < 256 ? result : 255;
    }

    public static RGB getColor(Integer index) {
        if (index == null) {
            return null;
        }
        if (index >= 0 && index < palette.length) {
            return palette[index];
        }
        if (index >= 16 && index < 232) {
            int color = index - 16;
            int blue = color % 6;
            int green = (color /= 6) % 6;
            int red = color / 6;
            return new RGB(AnsiConsoleColorPalette.safe256(red, 6), AnsiConsoleColorPalette.safe256(green, 6), AnsiConsoleColorPalette.safe256(blue, 6));
        }
        if (index >= 232 && index < 256) {
            int gray = AnsiConsoleColorPalette.safe256(index - 232, 24);
            return new RGB(gray, gray, gray);
        }
        return null;
    }

    public static String getPalette() {
        return currentPaletteName;
    }

    public static void setPalette(String paletteName) {
        currentPaletteName = paletteName;
        if (PALETTE_VGA.equalsIgnoreCase(paletteName)) {
            palette = paletteVGA;
        } else if (PALETTE_WINXP.equalsIgnoreCase(paletteName)) {
            palette = paletteXP;
        } else if (PALETTE_MAC.equalsIgnoreCase(paletteName)) {
            palette = paletteMac;
        } else if (PALETTE_PUTTY.equalsIgnoreCase(paletteName)) {
            palette = palettePuTTY;
        } else if (PALETTE_XTERM.equalsIgnoreCase(paletteName)) {
            palette = paletteXTerm;
        } else {
            String os = System.getProperty("os.name");
            if (os == null || os.startsWith("Windows")) {
                AnsiConsoleColorPalette.setPalette(PALETTE_WINXP);
            } else if (os.startsWith("Mac")) {
                AnsiConsoleColorPalette.setPalette(PALETTE_MAC);
            } else {
                AnsiConsoleColorPalette.setPalette(PALETTE_XTERM);
            }
        }
    }
}

