/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.dialogs.ZoneSelectionDialog;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ChangeZone
implements IObjectActionDelegate {
    private boolean zoningEnabled = ConsoleSharedData.getSession().isZoningEnabled();
    private IWorkbenchWindow window;
    private IWorkbenchPart part;
    private AbstractObject object;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
        this.window = targetPart.getSite().getWorkbenchWindow();
    }

    public void run(IAction action) {
        final ZoneSelectionDialog dlg = new ZoneSelectionDialog(this.window.getShell());
        if (dlg.open() != 0) {
            return;
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.ChangeZone_JobTitle, this.object.getObjectName(), this.object.getObjectId()), this.part, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.changeObjectZone(ChangeZone.this.object.getObjectId(), dlg.getZoneUIN());
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ChangeZone_JobError, ChangeZone.this.object.getObjectName(), ChangeZone.this.object.getObjectId());
            }
        }.start();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        this.object = selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 ? ((obj = ((IStructuredSelection)selection).getFirstElement()) instanceof AbstractNode || obj instanceof Cluster ? (AbstractObject)obj : null) : null;
        action.setEnabled(this.object != null && this.zoningEnabled);
    }
}

