/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class DeleteObject
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String question;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ISelection selection = window.getActivePage().getSelection();
        if (selection == null || !(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        if (((IStructuredSelection)selection).size() == 1) {
            Messages.get();
            question = String.format(Messages.DeleteObject_ConfirmQuestionSingular, ((AbstractObject)((IStructuredSelection)selection).getFirstElement()).getObjectName());
        } else {
            Messages.get();
            question = Messages.DeleteObject_ConfirmQuestionPlural;
        }
        Shell shell = window.getShell();
        Messages.get();
        boolean confirmed = MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.DeleteObject_ConfirmDelete, (String)question);
        if (confirmed && ((IStructuredSelection)selection).getFirstElement() instanceof AbstractObject) {
            final Object[] objects = ((IStructuredSelection)selection).toArray();
            Arrays.sort(objects, new Comparator<Object>(){

                @Override
                public int compare(Object arg0, Object arg1) {
                    if (arg0 instanceof AbstractObject && arg1 instanceof AbstractObject && ((AbstractObject)arg0).isChildOf(((AbstractObject)arg1).getObjectId())) {
                        return -1;
                    }
                    return 1;
                }
            });
            final NXCSession session = ConsoleSharedData.getSession();
            Messages.get();
            new ConsoleJob(Messages.DeleteObject_JobName, null, "org.netxms.ui.eclipse.imagelibrary", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    Object[] objectArray = objects;
                    int n = objects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof AbstractObject) {
                            session.deleteObject(((AbstractObject)o).getObjectId());
                        }
                        ++n2;
                    }
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.DeleteObject_JobError;
                }
            }.start();
        }
        return null;
    }
}

