/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.Zone;
import org.netxms.ui.eclipse.objectbrowser.widgets.ZoneSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class CreateClusterDialog
extends Dialog {
    private LabeledText nameField;
    private LabeledText aliasField;
    private ZoneSelector zoneSelector;
    private NXCSession session;
    private String name;
    private String alias;
    private int zoneUIN = 0;

    public CreateClusterDialog(Shell parentShell) {
        super(parentShell);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.CreateCluster_Cluster);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.nameField = new LabeledText(dialogArea, 0);
        this.nameField.setLabel("Name");
        this.nameField.getTextControl().setTextLimit(255);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 300;
        this.nameField.setLayoutData((Object)gd);
        this.aliasField = new LabeledText(dialogArea, 0);
        this.aliasField.setLabel("Alias");
        this.aliasField.getTextControl().setTextLimit(255);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.aliasField.setLayoutData((Object)gd);
        this.session = ConsoleSharedData.getSession();
        if (this.session.isZoningEnabled()) {
            this.zoneSelector = new ZoneSelector(dialogArea, 0, false);
            this.zoneSelector.setLabel("Zone");
            Zone zone = this.session.findZone(this.zoneUIN);
            this.zoneSelector.setZoneUIN(zone != null ? zone.getUIN() : -1);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            this.zoneSelector.setLayoutData((Object)gd);
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.name = this.nameField.getText().trim();
        this.alias = this.aliasField.getText().trim();
        if (this.name.isEmpty()) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Please provide non-empty object name");
            return;
        }
        if (this.session.isZoningEnabled()) {
            this.zoneUIN = this.zoneSelector.getZoneUIN();
        }
        super.okPressed();
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public int getZoneUIN() {
        return this.zoneUIN;
    }
}

