/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.GeoArea;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.GeoLocationControlMode;
import org.netxms.client.objects.DataCollectionTarget;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.osm.dialogs.GeoAreaSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class LocationControl
extends PropertyPage {
    private DataCollectionTarget object;
    private Set<Integer> geoAreas = new HashSet<Integer>();
    private Map<Integer, GeoArea> geoAreaCache = new HashMap<Integer, GeoArea>();
    private Button checkGenerateEvent;
    private Combo locationControlMode;
    private TableViewer areaListViewer;
    private Button addButton;
    private Button deleteButton;
    private boolean initialGenerateEventSelection;
    private GeoLocationControlMode initialLocationControlMode;
    private boolean isAreaListModified = false;

    protected Control createContents(Composite parent) {
        this.object = (DataCollectionTarget)this.getElement().getAdapter(DataCollectionTarget.class);
        this.initialGenerateEventSelection = this.object.isLocationChageEventGenerated();
        this.initialLocationControlMode = this.object.getGeoLocationControlMode();
        long[] lArray = this.object.getGeoAreas();
        int n = lArray.length;
        int n2 = 0;
        while (n2 < n) {
            long id = lArray[n2];
            this.geoAreas.add((int)id);
            ++n2;
        }
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        dialogArea.setLayout((Layout)layout);
        this.checkGenerateEvent = new Button(dialogArea, 32);
        this.checkGenerateEvent.setText("&Generate event when location changes");
        this.checkGenerateEvent.setSelection(this.object.isLocationChageEventGenerated());
        this.checkGenerateEvent.setLayoutData((Object)new GridData(4, 1024, true, false));
        this.locationControlMode = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)12, (String)"Location control mode", (Object)"WidgetHelper::default_layout_data");
        this.locationControlMode.add("No control");
        this.locationControlMode.add("Alert when within restricted area");
        this.locationControlMode.add("Alert when outside allowed area");
        this.locationControlMode.select(this.object.getGeoLocationControlMode().getValue());
        Composite viewerComposite = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.verticalSpacing = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        viewerComposite.setLayout((Layout)layout);
        viewerComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        new Label(viewerComposite, 16384).setText("Areas");
        this.areaListViewer = new TableViewer(viewerComposite, 2048);
        this.areaListViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.areaListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.areaListViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                GeoArea area1 = LocationControl.this.geoAreaCache.get((Integer)e1);
                GeoArea area2 = LocationControl.this.geoAreaCache.get((Integer)e2);
                String n1 = area1 != null ? area1.getName() : "[" + e1 + "]";
                String n2 = area2 != null ? area2.getName() : "[" + e2 + "]";
                return n1.compareToIgnoreCase(n2);
            }
        });
        this.areaListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                GeoArea area = LocationControl.this.geoAreaCache.get((Integer)element);
                return area != null ? area.getName() : "[" + element + "]";
            }
        });
        this.areaListViewer.setInput(this.geoAreas);
        Composite buttons = new Composite(dialogArea, 0);
        RowLayout buttonLayout = new RowLayout();
        buttonLayout.type = 256;
        buttonLayout.pack = false;
        buttonLayout.marginWidth = 0;
        buttons.setLayout((Layout)buttonLayout);
        GridData gd = new GridData();
        gd.horizontalAlignment = 131072;
        buttons.setLayoutData((Object)gd);
        this.addButton = new Button(buttons, 8);
        Messages.get();
        this.addButton.setText(Messages.TrustedNodes_Add);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                GeoAreaSelectionDialog dlg = new GeoAreaSelectionDialog(LocationControl.this.getShell(), new ArrayList<GeoArea>(LocationControl.this.geoAreaCache.values()));
                if (dlg.open() != 0) {
                    return;
                }
                int areaId = dlg.getAreaId();
                if (LocationControl.this.geoAreas.contains(areaId)) {
                    return;
                }
                LocationControl.this.geoAreas.add(areaId);
                LocationControl.this.areaListViewer.refresh();
                LocationControl.this.isAreaListModified = true;
            }
        });
        RowData rd = new RowData();
        rd.width = 90;
        this.addButton.setLayoutData((Object)rd);
        this.deleteButton = new Button(buttons, 8);
        Messages.get();
        this.deleteButton.setText(Messages.TrustedNodes_Delete);
        this.deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = LocationControl.this.areaListViewer.getStructuredSelection();
                Iterator it = selection.iterator();
                if (it.hasNext()) {
                    while (it.hasNext()) {
                        LocationControl.this.geoAreas.remove(it.next());
                    }
                    LocationControl.this.areaListViewer.refresh();
                    LocationControl.this.isAreaListModified = true;
                }
            }
        });
        rd = new RowData();
        rd.width = 90;
        this.deleteButton.setLayoutData((Object)rd);
        final NXCSession session = ConsoleSharedData.getSession();
        ConsoleJob job = new ConsoleJob("Read configured geographical areas", null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List areas = session.getGeoAreas();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (GeoArea a : areas) {
                            (this).LocationControl.this.geoAreaCache.put(a.getId(), a);
                        }
                        (this).LocationControl.this.areaListViewer.refresh(true);
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get configured geographical areas";
            }
        };
        job.setUser(false);
        job.start();
        return dialogArea;
    }

    protected boolean applyChanges(final boolean isApply) {
        if (this.checkGenerateEvent.getSelection() == this.initialGenerateEventSelection && GeoLocationControlMode.getByValue((int)this.locationControlMode.getSelectionIndex()) == this.initialLocationControlMode && !this.isAreaListModified) {
            return true;
        }
        final NXCObjectModificationData md = new NXCObjectModificationData(this.object.getObjectId());
        md.setGeoLocationControlMode(GeoLocationControlMode.getByValue((int)this.locationControlMode.getSelectionIndex()));
        md.setObjectFlags(this.checkGenerateEvent.getSelection() ? 8 : 0, 8);
        long[] areas = new long[this.geoAreas.size()];
        int index = 0;
        for (Integer id : this.geoAreas) {
            areas[index++] = id.intValue();
        }
        md.setGeoAreas(areas);
        if (isApply) {
            this.setValid(false);
        }
        final NXCSession session = ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.Location_JobName, this.object.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.Location_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            (this).LocationControl.this.isAreaListModified = false;
                            (this).LocationControl.this.initialGenerateEventSelection = (this).LocationControl.this.checkGenerateEvent.getSelection();
                            (this).LocationControl.this.initialLocationControlMode = md.getGeoLocationControlMode();
                            LocationControl.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.checkGenerateEvent.setSelection(false);
        this.locationControlMode.select(GeoLocationControlMode.NO_CONTROL.getValue());
        if (!this.geoAreas.isEmpty()) {
            this.geoAreas.clear();
            this.areaListViewer.refresh();
            this.isAreaListModified = true;
        }
    }
}

