/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.market.Repository;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class RepositorySelectionDialog
extends Dialog {
    private List<Repository> repositories;
    private Repository selection = null;
    private TableViewer viewer;

    public RepositorySelectionDialog(Shell parentShell, List<Repository> repositories) {
        super(parentShell);
        this.repositories = repositories;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select Repository");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 16384);
        label.setText("Available repositories");
        this.viewer = new TableViewer(dialogArea, 67588);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((Repository)element).getDescription();
            }
        });
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((Repository)e1).getDescription().compareToIgnoreCase(((Repository)e2).getDescription());
            }
        });
        this.viewer.setInput(this.repositories);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                RepositorySelectionDialog.this.okPressed();
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 500;
        gd.heightHint = 300;
        this.viewer.getControl().setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Warning", (String)"Plese select repository from the list then press OK");
            return;
        }
        this.selection = (Repository)selection.getFirstElement();
        super.okPressed();
    }

    public Repository getSelection() {
        return this.selection;
    }
}

