/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.serverconfig.views;

import java.util.Comparator;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.nebula.jface.gridviewer.GridTableViewer;
import org.eclipse.nebula.jface.gridviewer.GridViewerEditor;
import org.eclipse.nebula.widgets.grid.Grid;
import org.eclipse.nebula.widgets.grid.GridColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.mt.MappingTable;
import org.netxms.client.mt.MappingTableEntry;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.serverconfig.Messages;
import org.netxms.ui.eclipse.serverconfig.views.helpers.MappingTableEntryLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.NaturalOrderComparator;

public class MappingTableEditor
extends ViewPart
implements ISaveablePart2 {
    public static final String ID = "org.netxms.ui.eclipse.serverconfig.views.MappingTableEditor";
    public static final int COLUMN_KEY = 0;
    public static final int COLUMN_VALUE = 1;
    public static final int COLUMN_DESCRIPTION = 2;
    private int mappingTableId;
    private MappingTable mappingTable;
    private NXCSession session;
    private GridTableViewer viewer;
    private boolean modified = false;
    private Action actionNewRow;
    private Action actionDelete;
    private Action actionSave;
    private Action actionRefresh;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            this.mappingTableId = Integer.parseInt(site.getSecondaryId());
        }
        catch (Exception e) {
            throw new PartInitException("Internal error", (Throwable)e);
        }
        if (this.mappingTableId <= 0) {
            throw new PartInitException("Internal error");
        }
        Messages.get();
        this.setPartName(String.format(Messages.MappingTableEditor_InitialPartName, this.mappingTableId));
        this.session = ConsoleSharedData.getSession();
    }

    public void createPartControl(Composite parent) {
        this.viewer = new GridTableViewer(parent, 768);
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new MappingTableEntryLabelProvider());
        Grid grid = this.viewer.getGrid();
        grid.setHeaderVisible(true);
        grid.setCellSelectionEnabled(true);
        GridColumn column = new GridColumn(grid, 0);
        Messages.get();
        column.setText(Messages.MappingTableEditor_ColKey);
        column.setWidth(200);
        column = new GridColumn(grid, 0);
        Messages.get();
        column.setText(Messages.MappingTableEditor_ColValue);
        column.setWidth(200);
        column = new GridColumn(grid, 0);
        Messages.get();
        column.setText(Messages.MappingTableEditor_ColComments);
        column.setWidth(400);
        this.viewer.setColumnProperties(new String[]{"key", "value", "comments"});
        CellEditor[] editors = new CellEditor[]{new MappingTableCellEditor((Composite)this.viewer.getGrid()), new MappingTableCellEditor((Composite)this.viewer.getGrid()), new MappingTableCellEditor((Composite)this.viewer.getGrid())};
        this.viewer.setCellEditors(editors);
        this.viewer.setCellModifier((ICellModifier)new CellModifier());
        ColumnViewerEditorActivationStrategy activationStrategy = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.viewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && (event.keyCode == 13 || Character.isLetterOrDigit(event.character));
            }
        };
        GridViewerEditor.create((GridTableViewer)this.viewer, (ColumnViewerEditorActivationStrategy)activationStrategy, (int)58);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = MappingTableEditor.this.viewer.getStructuredSelection();
                MappingTableEditor.this.actionDelete.setEnabled(selection.size() > 0);
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
        this.refresh();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.serverconfig.context.MappingTableEditor");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                if (MappingTableEditor.this.modified) {
                    Shell shell = MappingTableEditor.this.getSite().getShell();
                    Messages.get();
                    Messages.get();
                    if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.MappingTableEditor_RefreshConfirmation, (String)Messages.MappingTableEditor_RefreshConfirmationText)) {
                        return;
                    }
                }
                MappingTableEditor.this.refresh();
            }
        };
        Messages.get();
        this.actionNewRow = new Action(Messages.MappingTableEditor_NewRow, SharedIcons.ADD_OBJECT){

            public void run() {
                MappingTableEditor.this.addNewRow();
            }
        };
        this.actionNewRow.setEnabled(false);
        this.actionNewRow.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.add_new_row");
        handlerService.activateHandler(this.actionNewRow.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionNewRow));
        Messages.get();
        this.actionDelete = new Action(Messages.MappingTableEditor_Delete, SharedIcons.DELETE_OBJECT){

            public void run() {
                MappingTableEditor.this.deleteRows();
            }
        };
        this.actionDelete.setEnabled(false);
        this.actionDelete.setActionDefinitionId("org.netxms.ui.eclipse.serverconfig.commands.delete_rows");
        handlerService.activateHandler(this.actionDelete.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionDelete));
        Messages.get();
        this.actionSave = new Action(Messages.MappingTableEditor_Save, SharedIcons.SAVE){

            public void run() {
                new SaveJob().start();
            }
        };
        this.actionSave.setEnabled(false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionNewRow);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionNewRow);
        manager.add((IAction)this.actionSave);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                MappingTableEditor.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionNewRow);
        manager.add((IAction)this.actionDelete);
    }

    public void setFocus() {
        this.viewer.getGrid().setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
        SaveJob job = new SaveJob();
        job.start();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    public int promptToSaveOnClose() {
        return 3;
    }

    private void refresh() {
        Messages.get();
        new ConsoleJob(Messages.MappingTableEditor_LoadJobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.serverconfig", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final MappingTable t = MappingTableEditor.this.session.getMappingTable(MappingTableEditor.this.mappingTableId);
                t.getData().sort(new Comparator<MappingTableEntry>(){

                    @Override
                    public int compare(MappingTableEntry e1, MappingTableEntry e2) {
                        return NaturalOrderComparator.compare((String)e1.getKey(), (String)e2.getKey());
                    }
                });
                t.getData().add(new MappingTableEntry(null, null, null));
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        (this).MappingTableEditor.this.mappingTable = t;
                        MappingTableEditor mappingTableEditor = MappingTableEditor.this;
                        Messages.get();
                        mappingTableEditor.setPartName(String.format(Messages.MappingTableEditor_PartName, (this).MappingTableEditor.this.mappingTable.getName()));
                        (this).MappingTableEditor.this.viewer.setInput((Object)(this).MappingTableEditor.this.mappingTable.getData());
                        (this).MappingTableEditor.this.actionNewRow.setEnabled(true);
                        MappingTableEditor.this.setModified(false);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.MappingTableEditor_LoadJobError;
            }
        }.start();
    }

    private void setModified(boolean m) {
        if (this.modified == m) {
            return;
        }
        this.modified = m;
        this.actionSave.setEnabled(m);
        this.firePropertyChange(257);
    }

    private void addNewRow() {
        if (this.mappingTable == null) {
            return;
        }
        MappingTableEntry e = (MappingTableEntry)this.mappingTable.getData().get(this.mappingTable.getData().size() - 1);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)e));
        this.viewer.editElement((Object)e, 0);
    }

    private void deleteRows() {
        IStructuredSelection selection = this.viewer.getStructuredSelection();
        if (selection.isEmpty()) {
            return;
        }
        for (Object o : selection.toList()) {
            this.mappingTable.getData().remove(o);
        }
        this.viewer.refresh();
        this.setModified(true);
    }

    public void dispose() {
        this.modified = false;
        this.firePropertyChange(257);
        super.dispose();
    }

    private class CellModifier
    implements ICellModifier {
        private CellModifier() {
        }

        public void modify(Object element, String property, Object value) {
            MappingTableEntry e;
            if (element instanceof Item) {
                element = ((Item)element).getData();
            }
            boolean pseudoEntry = (e = (MappingTableEntry)element).getKey() == null && e.getValue() == null && e.getDescription() == null;
            boolean changed = false;
            if (property.equals("key")) {
                if (e.getKey() == null || !e.getKey().equals(value)) {
                    e.setKey((String)value);
                    changed = true;
                }
            } else if (property.equals("value")) {
                if (e.getValue() == null || !e.getValue().equals(value)) {
                    e.setValue((String)value);
                    changed = true;
                }
            } else if (property.equals("comments") && (e.getDescription() == null || !e.getDescription().equals(value))) {
                e.setDescription((String)value);
                changed = true;
            }
            if (changed) {
                if (pseudoEntry) {
                    if (!e.isEmpty()) {
                        if (e.getKey() == null) {
                            e.setKey("");
                        }
                        if (e.getValue() == null) {
                            e.setValue("");
                        }
                        if (e.getDescription() == null) {
                            e.setDescription("");
                        }
                        MappingTableEditor.this.mappingTable.getData().add(new MappingTableEntry(null, null, null));
                    } else {
                        e.setKey(null);
                        e.setValue(null);
                        e.setDescription(null);
                    }
                }
                MappingTableEditor.this.viewer.refresh();
                MappingTableEditor.this.setModified(true);
            }
        }

        public Object getValue(Object element, String property) {
            MappingTableEntry e = (MappingTableEntry)element;
            if (property.equals("key")) {
                return e.getKey();
            }
            if (property.equals("value")) {
                return e.getValue();
            }
            if (property.equals("comments")) {
                return e.getDescription();
            }
            return null;
        }

        public boolean canModify(Object element, String property) {
            return true;
        }
    }

    private static class MappingTableCellEditor
    extends TextCellEditor {
        public MappingTableCellEditor(Composite parent) {
            super(parent);
        }

        protected void doSetValue(Object value) {
            super.doSetValue(value != null ? value : "");
        }

        public void activate(ColumnViewerEditorActivationEvent activationEvent) {
            super.activate(activationEvent);
            if (activationEvent.eventType == 1 && Character.isLetterOrDigit(activationEvent.character)) {
                ((Text)this.getControl()).setText(new String(new char[]{activationEvent.character}));
            }
        }

        protected void doSetFocus() {
            super.doSetFocus();
            ((Text)this.getControl()).clearSelection();
        }
    }

    private class SaveJob
    extends ConsoleJob {
        public SaveJob() {
            Messages.get();
            super(Messages.MappingTableEditor_SaveJobName, (IWorkbenchPart)MappingTableEditor.this, "org.netxms.ui.eclipse.serverconfig", null);
        }

        protected void runInternal(IProgressMonitor monitor) throws Exception {
            MappingTableEditor.this.mappingTable.getData().remove(MappingTableEditor.this.mappingTable.getData().size() - 1);
            MappingTableEditor.this.session.updateMappingTable(MappingTableEditor.this.mappingTable);
            this.runInUIThread(new Runnable(){

                @Override
                public void run() {
                    MappingTableEditor.this.setModified(false);
                }
            });
        }

        protected String getErrorMessage() {
            Messages.get();
            return Messages.MappingTableEditor_SaveJobError;
        }
    }
}

