/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.netxms.ui.eclipse.actions.ViewerProvider;

public abstract class TableRowAction
extends Action {
    protected ColumnViewer viewer;
    protected ViewerProvider viewerProvider;
    protected boolean selectionOnly;

    public TableRowAction(ColumnViewer viewer, ViewerProvider viewerProvider, boolean selectionOnly) {
        this.viewer = viewer;
        this.viewerProvider = viewerProvider;
        this.selectionOnly = selectionOnly;
    }

    public TableRowAction(ColumnViewer viewer, ViewerProvider viewerProvider, boolean selectionOnly, String text) {
        super(text);
        this.viewer = viewer;
        this.viewerProvider = viewerProvider;
        this.selectionOnly = selectionOnly;
    }

    public TableRowAction(ColumnViewer viewer, ViewerProvider viewerProvider, boolean selectionOnly, String text, ImageDescriptor image) {
        super(text, image);
        this.viewer = viewer;
        this.viewerProvider = viewerProvider;
        this.selectionOnly = selectionOnly;
    }

    public TableRowAction(ColumnViewer viewer, ViewerProvider viewerProvider, boolean selectionOnly, String text, int style) {
        super(text, style);
        this.viewer = viewer;
        this.viewerProvider = viewerProvider;
        this.selectionOnly = selectionOnly;
    }

    protected List<String[]> getRowsFromViewer(boolean withHeader) {
        ArrayList<String[]> data;
        block13: {
            TreeItem[] selection;
            block12: {
                TableItem[] selection2;
                int i;
                if (this.viewerProvider != null) {
                    this.viewer = this.viewerProvider.getViewer();
                }
                data = new ArrayList<String[]>();
                if (!(this.viewer instanceof TableViewer)) break block12;
                int numColumns = ((TableViewer)this.viewer).getTable().getColumnCount();
                if (numColumns == 0) {
                    numColumns = 1;
                }
                if (withHeader) {
                    TableColumn[] columns = ((TableViewer)this.viewer).getTable().getColumns();
                    String[] headerRow = new String[numColumns];
                    i = 0;
                    while (i < numColumns) {
                        headerRow[i] = columns[i].getText();
                        ++i;
                    }
                    data.add(headerRow);
                }
                TableItem[] tableItemArray = selection2 = this.selectionOnly ? ((TableViewer)this.viewer).getTable().getSelection() : ((TableViewer)this.viewer).getTable().getItems();
                int n = selection2.length;
                i = 0;
                while (i < n) {
                    TableItem item = tableItemArray[i];
                    String[] row = new String[numColumns];
                    int i2 = 0;
                    while (i2 < numColumns) {
                        row[i2] = item.getText(i2);
                        ++i2;
                    }
                    data.add(row);
                    ++i;
                }
                break block13;
            }
            if (!(this.viewer instanceof TreeViewer)) break block13;
            int numColumns = ((TreeViewer)this.viewer).getTree().getColumnCount();
            if (numColumns == 0) {
                numColumns = 1;
            }
            if (withHeader) {
                TreeColumn[] columns = ((TreeViewer)this.viewer).getTree().getColumns();
                String[] headerRow = new String[numColumns];
                int i = 0;
                while (i < numColumns) {
                    headerRow[i] = columns[i].getText();
                    ++i;
                }
                data.add(headerRow);
            }
            TreeItem[] treeItemArray = selection = this.selectionOnly ? ((TreeViewer)this.viewer).getTree().getSelection() : ((TreeViewer)this.viewer).getTree().getItems();
            int n = selection.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                String[] row = new String[numColumns];
                int i = 0;
                while (i < numColumns) {
                    row[i] = item.getText(i);
                    ++i;
                }
                data.add(row);
                if (!this.selectionOnly) {
                    TableRowAction.addSubItems(item, data, numColumns);
                }
                ++n2;
            }
        }
        return data;
    }

    private static void addSubItems(TreeItem root, List<String[]> data, int numColumns) {
        TreeItem[] treeItemArray = root.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            String[] row = new String[numColumns];
            int i = 0;
            while (i < numColumns) {
                row[i] = item.getText(i);
                ++i;
            }
            data.add(row);
            TableRowAction.addSubItems(item, data, numColumns);
            ++n2;
        }
    }
}

