/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console;

import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.LicenseProblem;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class LicenseProblemStatusLineItem
extends ContributionItem {
    private static final int DEFAULT_CHAR_WIDTH = 40;
    public static final int CALC_TRUE_WIDTH = -1;
    private int charWidth;
    private int widthHint = -1;
    private int heightHint = -1;
    private CLabel label;
    private Font font;
    private Composite statusLine = null;

    public LicenseProblemStatusLineItem(String id) {
        this(id, 40);
    }

    public LicenseProblemStatusLineItem(String id, int charWidth) {
        super(id);
        this.charWidth = charWidth;
    }

    public void fill(Composite parent) {
        this.statusLine = parent;
        FontData fd = JFaceResources.getDialogFont().getFontData()[0];
        fd.setStyle(1);
        this.font = new Font((Device)Display.getCurrent(), fd);
        Label sep = new Label(parent, 2);
        this.label = new CLabel(this.statusLine, 0x1000810);
        this.label.setFont(this.font);
        this.label.setText("LICENSE PROBLEM");
        this.label.setBackground(parent.getDisplay().getSystemColor(7));
        this.label.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                LicenseProblemStatusLineItem.this.font.dispose();
            }
        });
        if (this.charWidth == -1) {
            Point preferredSize = this.label.computeSize(-1, -1);
            this.widthHint = preferredSize.x;
            this.heightHint = preferredSize.y;
        } else if (this.widthHint < 0) {
            GC gc = new GC((Drawable)this.statusLine);
            gc.setFont(this.statusLine.getFont());
            FontMetrics fm = gc.getFontMetrics();
            this.widthHint = (int)(fm.getAverageCharacterWidth() * (double)this.charWidth);
            this.heightHint = fm.getHeight();
            gc.dispose();
        }
        StatusLineLayoutData data = new StatusLineLayoutData();
        data.widthHint = this.widthHint;
        this.label.setLayoutData((Object)data);
        data = new StatusLineLayoutData();
        data.heightHint = this.heightHint;
        sep.setLayoutData((Object)data);
        this.label.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
                LicenseProblemStatusLineItem.this.displayProblems();
            }
        });
    }

    public Point getDisplayLocation() {
        if (this.label != null && this.statusLine != null) {
            return this.statusLine.toDisplay(this.label.getLocation());
        }
        return null;
    }

    private void displayProblems() {
        LicenseProblem[] licenseProblems = ConsoleSharedData.getSession().getLicenseProblems();
        if (licenseProblems != null && licenseProblems.length > 0) {
            StringBuilder sb = new StringBuilder();
            LicenseProblem[] licenseProblemArray = licenseProblems;
            int n = licenseProblems.length;
            int n2 = 0;
            while (n2 < n) {
                LicenseProblem p = licenseProblemArray[n2];
                if (sb.length() == 0) {
                    sb.append("\r\n");
                }
                sb.append(p.getDescription());
                ++n2;
            }
            MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"License Problem", (String)sb.toString());
        }
    }
}

