/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.preferencepages;

import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.console.ServerClockContributionItem;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class WorkbenchGeneralPrefs
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button cbShowHeapMonitor;
    private Button cbShowTrayIcon;
    private Button cbHideWhenMinimized;
    private Button cbShowHiddenAttributes;
    private Button cbShowServerClock;

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 4;
        dialogArea.setLayout((Layout)layout);
        this.cbShowHeapMonitor = new Button(dialogArea, 32);
        Messages.get();
        this.cbShowHeapMonitor.setText(Messages.WorkbenchGeneralPrefs_show_heap);
        this.cbShowHeapMonitor.setSelection(this.getPreferenceStore().getBoolean("SHOW_MEMORY_MONITOR"));
        this.cbShowTrayIcon = new Button(dialogArea, 32);
        Messages.get();
        this.cbShowTrayIcon.setText(Messages.WorkbenchGeneralPrefs_show_tray_icon);
        this.cbShowTrayIcon.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("SHOW_TRAY_ICON"));
        this.cbHideWhenMinimized = new Button(dialogArea, 32);
        Messages.get();
        this.cbHideWhenMinimized.setText(Messages.WorkbenchGeneralPrefs_HideWhenMinimized);
        this.cbHideWhenMinimized.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("HIDE_WHEN_MINIMIZED"));
        this.cbHideWhenMinimized.setEnabled(this.cbShowTrayIcon.getSelection());
        this.cbShowHiddenAttributes = new Button(dialogArea, 32);
        Messages.get();
        this.cbShowHiddenAttributes.setText(Messages.WorkbenchGeneralPrefs_ShowHiddenAttrs);
        this.cbShowHiddenAttributes.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("SHOW_HIDDEN_ATTRIBUTES"));
        this.cbShowServerClock = new Button(dialogArea, 32);
        Messages.get();
        this.cbShowServerClock.setText(Messages.WorkbenchGeneralPrefs_ShowServerClock);
        this.cbShowServerClock.setSelection(Activator.getDefault().getPreferenceStore().getBoolean("SHOW_SERVER_CLOCK"));
        this.cbShowTrayIcon.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (WorkbenchGeneralPrefs.this.cbShowTrayIcon.getSelection()) {
                    WorkbenchGeneralPrefs.this.cbHideWhenMinimized.setEnabled(true);
                } else {
                    WorkbenchGeneralPrefs.this.cbHideWhenMinimized.setEnabled(false);
                    WorkbenchGeneralPrefs.this.cbHideWhenMinimized.setSelection(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return dialogArea;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(PlatformUI.getPreferenceStore());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.cbShowHeapMonitor.setSelection(true);
        this.cbShowTrayIcon.setSelection(true);
        this.cbHideWhenMinimized.setSelection(false);
        this.cbShowHiddenAttributes.setSelection(false);
        this.cbShowServerClock.setSelection(false);
    }

    public boolean performOk() {
        this.getPreferenceStore().setValue("SHOW_MEMORY_MONITOR", this.cbShowHeapMonitor.getSelection());
        Activator.getDefault().getPreferenceStore().setValue("SHOW_TRAY_ICON", this.cbShowTrayIcon.getSelection());
        Activator.getDefault().getPreferenceStore().setValue("HIDE_WHEN_MINIMIZED", this.cbHideWhenMinimized.getSelection() && this.cbShowTrayIcon.getSelection());
        Activator.getDefault().getPreferenceStore().setValue("SHOW_HIDDEN_ATTRIBUTES", this.cbShowHiddenAttributes.getSelection());
        Activator.getDefault().getPreferenceStore().setValue("SHOW_SERVER_CLOCK", this.cbShowServerClock.getSelection());
        if (this.cbShowTrayIcon.getSelection()) {
            Activator.showTrayIcon();
        } else {
            Activator.hideTrayIcon();
        }
        ICoolBarManager coolBar = (ICoolBarManager)ConsoleSharedData.getProperty("CoolBarManager");
        if (this.cbShowServerClock.getSelection()) {
            if (coolBar.find("org.netxms.ui.eclipse.console.ServerClockContribution") == null) {
                coolBar.add((IContributionItem)new ServerClockContributionItem());
                coolBar.update(true);
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().layout(true, true);
            }
        } else {
            IContributionItem item = coolBar.find("org.netxms.ui.eclipse.console.ServerClockContribution");
            if (item != null) {
                coolBar.remove(item);
                coolBar.update(true);
            }
        }
        return super.performOk();
    }
}

