/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.console.resources;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.jface.preference.IPreferenceStore;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.TimeFormatter;
import org.netxms.ui.eclipse.console.Activator;
import org.netxms.ui.eclipse.console.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class RegionalSettings {
    public static final int DATETIME_FORMAT_SERVER = 0;
    public static final int DATETIME_FORMAT_JVM = 1;
    public static final int DATETIME_FORMAT_CUSTOM = 2;
    public static final TimeFormatter TIME_FORMATTER = new TimeFormatter(){

        public String formatUptime(long seconds) {
            return RegionalSettings.formatTimeDifference(seconds, true);
        }

        public String formatDateAndTime(long timestamp) {
            return RegionalSettings.getDateTimeFormat().format(new Date(timestamp * 1000L));
        }
    };
    private static int dateTimeFormat = 0;
    private static String dateFormatString;
    private static String timeFormatString;
    private static String shortTimeFormatString;

    public static void updateFromPreferences() {
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        dateTimeFormat = ps.getInt("DATETIME_FORMAT");
        dateFormatString = ps.getString("DATE_FORMAT_STRING");
        timeFormatString = ps.getString("TIME_FORMAT_STRING");
        shortTimeFormatString = ps.getString("SHORT_TIME_FORMAT_STRING");
        if (ps.getBoolean("USE_SERVER_TIMEZONE")) {
            ConsoleSharedData.setServerTimeZone();
        } else {
            ConsoleSharedData.resetTimeZone();
        }
    }

    public static DateFormat getDateTimeFormat() {
        DateFormat df = switch (dateTimeFormat) {
            case 0 -> {
                NXCSession session = ConsoleSharedData.getSession();
                yield new SimpleDateFormat(String.valueOf(session.getDateFormat()) + " " + session.getTimeFormat());
            }
            case 2 -> {
                try {
                    yield new SimpleDateFormat(String.valueOf(dateFormatString) + " " + timeFormatString);
                }
                catch (IllegalArgumentException e) {
                    yield DateFormat.getDateTimeInstance(3, 2);
                }
            }
            default -> DateFormat.getDateTimeInstance(3, 2);
        };
        TimeZone tz = ConsoleSharedData.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getDateFormat() {
        DateFormat df = switch (dateTimeFormat) {
            case 0 -> {
                NXCSession session = ConsoleSharedData.getSession();
                yield new SimpleDateFormat(session.getDateFormat());
            }
            case 2 -> {
                try {
                    yield new SimpleDateFormat(dateFormatString);
                }
                catch (IllegalArgumentException e) {
                    yield DateFormat.getDateInstance(3);
                }
            }
            default -> DateFormat.getDateInstance(3);
        };
        TimeZone tz = ConsoleSharedData.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getTimeFormat() {
        DateFormat df = switch (dateTimeFormat) {
            case 0 -> {
                NXCSession session = ConsoleSharedData.getSession();
                yield new SimpleDateFormat(session.getTimeFormat());
            }
            case 2 -> {
                try {
                    yield new SimpleDateFormat(timeFormatString);
                }
                catch (IllegalArgumentException e) {
                    yield DateFormat.getTimeInstance(2);
                }
            }
            default -> DateFormat.getTimeInstance(2);
        };
        TimeZone tz = ConsoleSharedData.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static DateFormat getShortTimeFormat() {
        DateFormat df = switch (dateTimeFormat) {
            case 0 -> {
                NXCSession session = ConsoleSharedData.getSession();
                yield new SimpleDateFormat(session.getShortTimeFormat());
            }
            case 2 -> {
                try {
                    yield new SimpleDateFormat(shortTimeFormatString);
                }
                catch (IllegalArgumentException e) {
                    yield DateFormat.getTimeInstance(3);
                }
            }
            default -> DateFormat.getTimeInstance(3);
        };
        TimeZone tz = ConsoleSharedData.getTimeZone();
        if (tz != null) {
            df.setTimeZone(tz);
        }
        return df;
    }

    public static String formatTimeDifference(long seconds, boolean showSeconds) {
        long hours;
        StringBuilder sb = new StringBuilder();
        long days = seconds / 86400L;
        if (days > 0L) {
            sb.append(days);
            Messages.get();
            sb.append(Messages.RegionalSettings_Days);
            seconds -= days * 86400L;
        }
        if ((hours = seconds / 3600L) < 10L) {
            sb.append('0');
        }
        sb.append(hours);
        sb.append(':');
        long minutes = (seconds -= hours * 3600L) / 60L;
        if (minutes < 10L) {
            sb.append('0');
        }
        sb.append(minutes);
        if (showSeconds) {
            sb.append(':');
            if ((seconds %= 60L) < 10L) {
                sb.append('0');
            }
            sb.append(seconds);
        }
        return sb.toString();
    }

    public static String formatTimeDifference(Date start, boolean showSeconds) {
        long seconds = (System.currentTimeMillis() - start.getTime()) / 1000L;
        return RegionalSettings.formatTimeDifference(seconds, showSeconds);
    }
}

